/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.statistics.sumdownstream.OmsSumDownStream;

@Description(value="Sums the values of a map downstream following the flowdirections.")
@Author(name="Daniele Andreis, Antonello Andrea, Erica Ghesla, Cozzini Andrea, Franceschi Silvia, Pisoni Silvano, Rigon Riccardo", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Sumdownstream, Statistic, OmsExtractNetwork")
@Label(value="HortonMachine/Statistics")
@Name(value="_sumdownstream")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class SumDownStream
extends HMModel {
    @Description(value="The map of flowdirections.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The map to sum.")
    @UI(value="infile_raster")
    @In
    public String inToSum = null;
    @Description(value="The upper threshold.")
    @In
    public Double pUpperThres = null;
    @Description(value="The lower threshold.")
    @In
    public Double pLowerThres = null;
    @Description(value="The map of summed values.")
    @UI(value="outfile")
    @In
    public String outSummed = null;

    @Execute
    public void process() throws Exception {
        OmsSumDownStream sumdownstream = new OmsSumDownStream();
        sumdownstream.inFlow = this.getRaster(this.inFlow);
        sumdownstream.inToSum = this.getRaster(this.inToSum);
        sumdownstream.pUpperThres = this.pUpperThres;
        sumdownstream.pLowerThres = this.pLowerThres;
        sumdownstream.pm = this.pm;
        sumdownstream.doProcess = this.doProcess;
        sumdownstream.doReset = this.doReset;
        sumdownstream.process();
        this.dumpRaster(sumdownstream.outSummed, this.outSummed);
    }
}

