/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.network.strahler.OmsStrahlerRatios;

@Description(value="Calculates the OmsStrahler ratios.")
@Author(name="Antonello Andrea, Silvia Franceschi", contact="http://www.hydrologis.com")
@Keywords(value="Network, OmsStrahler")
@Label(value="HortonMachine/Network")
@Name(value="_strahlerratio")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class StrahlerRatios
extends HMModel {
    @Description(value="The map of flowdirections.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The map of OmsStrahler.")
    @UI(value="infile_raster")
    @In
    public String inStrahler = null;
    @Description(value="The map of the network.")
    @UI(value="infile_vector")
    @In
    public String inNet = null;
    @Description(value="The bifurcation ratio.")
    @In
    public double outBisfurcation;
    @Description(value="The area ratio.")
    @In
    public double outArea;
    @Description(value="The length ratio.")
    @In
    public double outLength;

    @Execute
    public void process() throws Exception {
        OmsStrahlerRatios omsstrahlerratios = new OmsStrahlerRatios();
        omsstrahlerratios.inFlow = this.getRaster(this.inFlow);
        omsstrahlerratios.inStrahler = this.getRaster(this.inStrahler);
        omsstrahlerratios.inNet = this.getVector(this.inNet);
        omsstrahlerratios.pm = this.pm;
        omsstrahlerratios.doProcess = this.doProcess;
        omsstrahlerratios.doReset = this.doReset;
        omsstrahlerratios.process();
        this.outBisfurcation = omsstrahlerratios.outBisfurcation;
        this.outArea = omsstrahlerratios.outArea;
        this.outLength = omsstrahlerratios.outLength;
    }
}

