/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.shalstab.OmsShalstab;

@Description(value="A version of the OmsShalstab stability model.")
@Author(name="Daniele Andreis, Antonello Andrea, Erica Ghesla, Cozzini Andrea, Franceschi Silvia, Pisoni Silvano, Rigon Riccardo", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="OmsShalstab, Hydrology, Trasmissivity")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="_shalstab")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Shalstab
extends HMModel {
    @Description(value="The map of slope.")
    @UI(value="infile_raster")
    @In
    public String inSlope = null;
    @Description(value="The map of contributing area.")
    @UI(value="infile_raster")
    @In
    public String inTca = null;
    @Description(value="The map of trasmissivity.")
    @UI(value="infile_raster")
    @Unit(value="m^2/day")
    @In
    public String inTrasmissivity = null;
    @Description(value="A constant of trasmissivity to use instead of the map.")
    @Unit(value="m^2/day")
    @In
    public double pTrasmissivity = -1.0;
    @Description(value="The map of the tangent of the friction tangent angle.")
    @UI(value="infile_raster")
    @In
    public String inTgphi = null;
    @Description(value="A constant of tangent of the friction angle to use instead of the map.")
    @In
    public double pTgphi = -1.0;
    @Description(value="The map of cohesion.")
    @UI(value="infile_raster")
    @Unit(value="Pa")
    @In
    public String inCohesion = null;
    @Description(value="A constant of cohesion to use instead of the map.")
    @Unit(value="Pa")
    @In
    public double pCohesion = -1.0;
    @Description(value="The map of soil depth.")
    @UI(value="infile_raster")
    @Unit(value="m")
    @In
    public String inSdepth = null;
    @Description(value="A constant of soil depth to use instead of the map.")
    @Unit(value="m")
    @In
    public double pSdepth = -1.0;
    @Description(value="The map of effective precipitation.")
    @UI(value="infile_raster")
    @Unit(value="mm/day")
    @In
    public String inQ = null;
    @Description(value="A constant of effective precipitation to use instead of the map.")
    @Unit(value="mm/day")
    @In
    public double pQ = -1.0;
    @Description(value="The map of rho.")
    @UI(value="infile_raster")
    @In
    public String inRho = null;
    @Description(value="A constant of rho to use instead of the map.")
    @In
    public double pRho = -1.0;
    @Description(value="A value for the slope for rock.")
    @In
    public double pRock = -9999.0;
    @Description(value="The map of qcrit.")
    @UI(value="outfile")
    @In
    public String outQcrit = null;
    @Description(value="The map of classi.")
    @UI(value="outfile")
    @In
    public String outShalstab = null;

    @Execute
    public void process() throws Exception {
        OmsShalstab shalstab = new OmsShalstab();
        shalstab.inSlope = this.getRaster(this.inSlope);
        shalstab.inTca = this.getRaster(this.inTca);
        shalstab.inTrasmissivity = this.getRaster(this.inTrasmissivity);
        shalstab.pTrasmissivity = this.pTrasmissivity;
        shalstab.inTgphi = this.getRaster(this.inTgphi);
        shalstab.pTgphi = this.pTgphi;
        shalstab.inCohesion = this.getRaster(this.inCohesion);
        shalstab.pCohesion = this.pCohesion;
        shalstab.inSdepth = this.getRaster(this.inSdepth);
        shalstab.pSdepth = this.pSdepth;
        shalstab.inQ = this.getRaster(this.inQ);
        shalstab.pQ = this.pQ;
        shalstab.inRho = this.getRaster(this.inRho);
        shalstab.pRho = this.pRho;
        shalstab.pRock = this.pRock;
        shalstab.pm = this.pm;
        shalstab.doProcess = this.doProcess;
        shalstab.doReset = this.doReset;
        shalstab.process();
        this.dumpRaster(shalstab.outQcrit, this.outQcrit);
        this.dumpRaster(shalstab.outShalstab, this.outShalstab);
    }
}

