/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.io.rasterwriter.OmsRasterWriter;
import org.hortonmachine.gears.libs.modules.HMModel;

@Description(value="Raster writer module.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Grass, Coverage, Raster, Writing")
@Label(value="Raster Writer")
@Name(value="_rasterwriter")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class RasterWriter
extends HMModel {
    @Description(value="The raster map to write.")
    @In
    public GridCoverage2D inRaster = null;
    @Description(value="The file to write the raster to with extension (supported are: asc, tiff, grass).")
    @UI(value="outfile")
    @In
    public String file = null;

    @Execute
    public void process() throws Exception {
        OmsRasterWriter rasterwriter = new OmsRasterWriter();
        rasterwriter.inRaster = this.inRaster;
        rasterwriter.file = this.file;
        rasterwriter.pm = this.pm;
        rasterwriter.doProcess = this.doProcess;
        rasterwriter.doReset = this.doReset;
        rasterwriter.process();
    }

    public static void writeRaster(String path, GridCoverage2D coverage) throws Exception {
        OmsRasterWriter.writeRaster((String)path, (GridCoverage2D)coverage);
    }
}

