/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.transformer.OmsRasterTransformer;

@Description(value="Module for raster tranforms.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Transform, Raster")
@Label(value="Raster Processing")
@Name(value="_rtrans")
@Status(value=10)
@License(value="General Public License Version 3 (GPLv3)")
public class RasterTransformer
extends HMModel {
    @Description(value="The raster that has to be transformed.")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="The interpolation type to use")
    @UI(value="combo:nearest neightbour,bilinear,bicubic")
    @In
    public String pInterpolation = "nearest neightbour";
    @Description(value="The translation along the X axis.")
    @Unit(value="m")
    @In
    public Double pTransX;
    @Description(value="The translation along the Y axis.")
    @Unit(value="m")
    @In
    public Double pTransY;
    @Description(value="The scale factor along X axis.")
    @In
    public Double pScaleX;
    @Description(value="The scale factor along the Y axis.")
    @In
    public Double pScaleY;
    @Description(value="Flip horizontally.")
    @In
    public boolean doFlipHorizontal;
    @Description(value="Flip vertically.")
    @In
    public boolean doFlipVertical;
    @Description(value="The northern coordinate of the rotation point.")
    @UI(value="northing")
    @In
    public Double pNorth;
    @Description(value="The eastern coordinate of the rotation point.")
    @UI(value="easting")
    @In
    public Double pEast;
    @Description(value="The rotation angle in degree (rotation is performed before translation).")
    @Unit(value="degrees")
    @In
    public Double pAngle;
    @Description(value="The transformed raster.")
    @UI(value="outfile")
    @In
    public String outRaster = null;
    @Description(value="The new raster geometry.")
    @UI(value="outfile")
    @In
    public String outBounds = null;

    @Execute
    public void process() throws Exception {
        OmsRasterTransformer rastertransformer = new OmsRasterTransformer();
        rastertransformer.inRaster = this.getRaster(this.inRaster);
        rastertransformer.pInterpolation = this.pInterpolation;
        rastertransformer.pTransX = this.pTransX;
        rastertransformer.pTransY = this.pTransY;
        rastertransformer.pScaleX = this.pScaleX;
        rastertransformer.pScaleY = this.pScaleY;
        rastertransformer.doFlipHorizontal = this.doFlipHorizontal;
        rastertransformer.doFlipVertical = this.doFlipVertical;
        rastertransformer.pNorth = this.pNorth;
        rastertransformer.pEast = this.pEast;
        rastertransformer.pAngle = this.pAngle;
        rastertransformer.pm = this.pm;
        rastertransformer.doProcess = this.doProcess;
        rastertransformer.doReset = this.doReset;
        rastertransformer.process();
        this.dumpRaster(rastertransformer.outRaster, this.outRaster);
        this.dumpVector(rastertransformer.outBounds, this.outBounds);
    }
}

