/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.transformer.OmsRasterResolutionResampler;

@Description(value="Module to do coverage resolution resampling.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Coverage, Raster, Convert")
@Label(value="Raster Processing")
@Name(value="_rresolresampler")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class RasterResolutionResampler
extends HMModel {
    @Description(value="The input coverage.")
    @UI(value="infile_raster")
    @In
    public String inGeodata;
    @Description(value="The interpolation type to use")
    @UI(value="combo:nearest neightbour,bilinear,bicubic")
    @In
    public String pInterpolation = "nearest neightbour";
    @Description(value="The new resolution in X")
    @In
    public Double pXres;
    @Description(value="The new resolution in Y (if null taken same as pXres)")
    @In
    public Double pYres;
    @Description(value="The output coverage.")
    @UI(value="outfile")
    @In
    public String outGeodata;

    @Execute
    public void process() throws Exception {
        OmsRasterResolutionResampler rasterresolutionresampler = new OmsRasterResolutionResampler();
        rasterresolutionresampler.inGeodata = this.getRaster(this.inGeodata);
        rasterresolutionresampler.pInterpolation = this.pInterpolation;
        rasterresolutionresampler.pXres = this.pXres;
        rasterresolutionresampler.pYres = this.pYres;
        rasterresolutionresampler.pm = this.pm;
        rasterresolutionresampler.doProcess = this.doProcess;
        rasterresolutionresampler.doReset = this.doReset;
        rasterresolutionresampler.process();
        this.dumpRaster(rasterresolutionresampler.outGeodata, this.outGeodata);
    }
}

