/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.rasteronvectorresizer.OmsRasterResizer;

@Description(value="Module to resize a raster on a raster or vector using the resolution of the original raster. Snapping is applied to the first contained cell, if necessary.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, Resize")
@Label(value="Raster Processing")
@Name(value="_rresizer")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class RasterResizer
extends HMModel {
    @Description(value="The optional polygon vector to use for the bounds.")
    @UI(value="infile_vector")
    @In
    public String inVector = null;
    @Description(value="The optional raster to use as mask.")
    @UI(value="infile_raster")
    @In
    public String inMaskRaster;
    @Description(value="The raster to resize.")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="The resized raster.")
    @UI(value="outfile")
    @In
    public String outRaster;

    @Execute
    public void process() throws Exception {
        OmsRasterResizer r = new OmsRasterResizer();
        r.inRaster = this.getRaster(this.inRaster);
        r.inMaskRaster = this.getRaster(this.inMaskRaster);
        r.inVector = this.getVector(this.inVector);
        r.pm = this.pm;
        r.doProcess = this.doProcess;
        r.doReset = this.doReset;
        r.process();
        this.dumpRaster(r.outRaster, this.outRaster);
    }

    public static void main(String[] args) throws Exception {
        RasterResizer r = new RasterResizer();
        r.inMaskRaster = "/Users/hydrologis/Dropbox/hydrologis/lavori/2020_klab/hydrology/INVEST/testGura/DEM_gura.tif";
        r.inRaster = "/Users/hydrologis/Dropbox/hydrologis/lavori/2020_klab/hydrology/INVEST/testGura/evapotranspiration_toni/ET0_gura_1.tif";
        r.outRaster = "/Users/hydrologis/Dropbox/hydrologis/lavori/2020_klab/hydrology/INVEST/testGura/evapotranspiration_toni/ET0_gura_onDEM.tif";
        r.process();
    }
}

