/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.rasterdiff.OmsRasterDiff;

@Description(value="Raster diff module.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Coverage, Raster, Correct, OmsRasterReader")
@Label(value="Raster Processing")
@Name(value="rdiff")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class RasterDiff
extends HMModel {
    @Description(value="The input raster.")
    @UI(value="infile_raster")
    @In
    public String inRaster1;
    @Description(value="The raster to subtract.")
    @UI(value="infile_raster")
    @In
    public String inRaster2;
    @Description(value="The threshold, under which to set novalue.")
    @In
    public Double pThreshold;
    @Description(value="Allow negative values.")
    @In
    public boolean doNegatives = true;
    @Description(value="The output raster.")
    @UI(value="outfile")
    @In
    public String outRaster;

    @Execute
    public void process() throws Exception {
        OmsRasterDiff rasterdiff = new OmsRasterDiff();
        rasterdiff.inRaster1 = this.getRaster(this.inRaster1);
        rasterdiff.inRaster2 = this.getRaster(this.inRaster2);
        rasterdiff.pThreshold = this.pThreshold;
        rasterdiff.doNegatives = this.doNegatives;
        rasterdiff.pm = this.pm;
        rasterdiff.doProcess = this.doProcess;
        rasterdiff.doReset = this.doReset;
        rasterdiff.process();
        this.dumpRaster(rasterdiff.outRaster, this.outRaster);
    }
}

