/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.profile.OmsProfile;

@Description(value="Module creating profiles over rasters.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="OmsProfile, Raster")
@Label(value="Raster Processing")
@Name(value="_profile")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class Profile
extends HMModel {
    @Description(value="The raster map to use for the profile")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="Comma separated list of easting,northing coordinates to trace the profile on (optional).")
    @In
    public String inCoordinates;
    @Description(value="Line vector map to use to trace the profile on (optional).")
    @UI(value="infile_vector")
    @In
    public String inVector;
    @Description(value="The id of the line to use for the name of the profile output file name (used in case of inVector use).")
    @In
    public String fLineid;
    @Description(value="The folder in which to place the output profiles if multiple (used in case of inVector use).")
    @UI(value="outfolder")
    @In
    public String outFolder;
    @Description(value="The output profile for the last line read (contains progressive, elevation, x, y).")
    @Out
    public double[][] outProfile;

    @Execute
    public void process() throws Exception {
        OmsProfile profile = new OmsProfile();
        profile.inRaster = this.getRaster(this.inRaster);
        profile.inCoordinates = this.inCoordinates;
        profile.inVector = this.getVector(this.inVector);
        profile.fLineid = this.fLineid;
        profile.outFolder = this.outFolder;
        profile.pm = this.pm;
        profile.doProcess = this.doProcess;
        profile.doReset = this.doReset;
        profile.process();
        this.outProfile = profile.outProfile;
    }
}

