/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.net.URISyntaxException;
import java.util.HashMap;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.io.timedependent.OmsTimeSeriesIteratorReader;
import org.hortonmachine.gears.io.timedependent.OmsTimeSeriesIteratorWriter;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.etp.OmsPresteyTaylorEtpModel;

@Description(value="Calculates evapotranspiration based on the Prestey-Taylor model.")
@Author(name="Giuseppe Formetta, Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Evapotranspiration, Hydrologic")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="_ptetp")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
@UI(value="iterator")
public class PresteyTaylorEtpModel
extends HMModel {
    @Description(value="The net Radiation at the grass surface in W/m2 for the current hour.")
    @UI(value="infile_csv")
    @In
    @Unit(value="Watt m-2 ")
    public String inNetradiation;
    @Description(value="The daily net Radiation default value in case of missing data.")
    @In
    @Unit(value="Watt m-2")
    public double defaultDailyNetradiation = 300.0;
    @Description(value="The hourly net Radiation default value in case of missing data.")
    @In
    @Unit(value="Watt m-2")
    public double defaultHourlyNetradiation = 100.0;
    @Description(value="Switch that defines if it is hourly.")
    @In
    public boolean doHourly;
    @Description(value="The common id name for the data reading.")
    @In
    public String fDataID;
    @Description(value="The mean hourly air temperature.")
    @UI(value="infile_csv")
    @In
    @Unit(value="C")
    public String inTemp;
    @Description(value="The alpha.")
    @In
    @Unit(value="m")
    public double pAlpha = 0.0;
    @Description(value="The g morning.")
    @In
    public double pGmorn = 0.0;
    @Description(value="The g nigth.")
    @In
    public double pGnight = 0.0;
    @Description(value="The temperature default value in case of missing data.")
    @In
    @Unit(value="C")
    public double defaultTemp = 15.0;
    @Description(value="The atmospheric pressure in KPa.")
    @UI(value="infile_csv")
    @In
    @Unit(value="KPa")
    public String inPressure;
    @Description(value="The pressure default value in case of missing data.")
    @In
    @Unit(value="KPa")
    public double defaultPressure = 101.3;
    @Description(value="The reference evapotranspiration.")
    @UI(value="outfile")
    @Unit(value="mm hour-1")
    @In
    public String outPTEtp;

    @Execute
    public void process() throws Exception {
        OmsTimeSeriesIteratorReader tempReader = this.getTimeseriesReader(this.inTemp, this.fDataID);
        OmsTimeSeriesIteratorReader pressReader = null;
        if (this.inPressure != null) {
            pressReader = this.getTimeseriesReader(this.inPressure, this.fDataID);
        }
        OmsTimeSeriesIteratorReader netradReader = null;
        if (this.inNetradiation != null) {
            netradReader = this.getTimeseriesReader(this.inNetradiation, this.fDataID);
        }
        OmsPresteyTaylorEtpModel omspresteytayloretpmodel = new OmsPresteyTaylorEtpModel();
        omspresteytayloretpmodel.defaultPressure = this.defaultPressure;
        omspresteytayloretpmodel.pAlpha = this.pAlpha;
        omspresteytayloretpmodel.pGmorn = this.pGmorn;
        omspresteytayloretpmodel.pGnight = this.pGnight;
        omspresteytayloretpmodel.doHourly = this.doHourly;
        omspresteytayloretpmodel.pm = this.pm;
        omspresteytayloretpmodel.defaultDailyNetradiation = this.defaultDailyNetradiation;
        omspresteytayloretpmodel.defaultHourlyNetradiation = this.defaultHourlyNetradiation;
        omspresteytayloretpmodel.defaultTemp = this.defaultTemp;
        OmsTimeSeriesIteratorWriter writerCalculatedEtp = null;
        this.pm.beginTask("Processing...", -1);
        while (tempReader.doProcess) {
            HashMap outEtp;
            HashMap id2ValueMap;
            tempReader.nextRecord();
            omspresteytayloretpmodel.inTemp = id2ValueMap = tempReader.outData;
            omspresteytayloretpmodel.tCurrent = tempReader.tCurrent;
            if (writerCalculatedEtp == null) {
                writerCalculatedEtp = new OmsTimeSeriesIteratorWriter();
                writerCalculatedEtp.file = this.outPTEtp;
                writerCalculatedEtp.tStart = tempReader.tStart;
                writerCalculatedEtp.tTimestep = tempReader.tTimestep;
            }
            this.pm.message("timestep: " + tempReader.tCurrent);
            if (pressReader != null) {
                pressReader.nextRecord();
                omspresteytayloretpmodel.inPressure = id2ValueMap = pressReader.outData;
            }
            if (netradReader != null) {
                netradReader.nextRecord();
                omspresteytayloretpmodel.inNetradiation = id2ValueMap = netradReader.outData;
            }
            omspresteytayloretpmodel.process();
            writerCalculatedEtp.inData = outEtp = omspresteytayloretpmodel.outPTEtp;
            writerCalculatedEtp.writeNextLine();
        }
        this.pm.done();
        tempReader.close();
        if (pressReader != null) {
            pressReader.close();
        }
        if (netradReader != null) {
            netradReader.close();
        }
        writerCalculatedEtp.close();
    }

    private OmsTimeSeriesIteratorReader getTimeseriesReader(String path, String id) throws URISyntaxException {
        OmsTimeSeriesIteratorReader reader = new OmsTimeSeriesIteratorReader();
        reader.file = path;
        reader.idfield = id;
        reader.fileNovalue = "-9999";
        reader.initProcess();
        return reader;
    }
}

