/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.modules.docker.PdalDockerModel;
import org.json.JSONObject;

@Description(value="PDAL filter.returns command.")
@Author(name="Antonello Andrea", contact="http://www.hydrologis.com")
@Keywords(value="pdal, docker")
@Label(value="Pdal")
@Name(value="_pdal_filter_returns")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class PdalFilterReturns
extends PdalDockerModel {
    @Description(value="The pdal file to filter.")
    @UI(value="infile_las")
    @In
    public String inPath = null;
    @Description(value="The output file name.")
    @In
    public String outName = null;
    @Description(value="List of impulses to extract. Can be one or more of: first, last, intermediate, only")
    @In
    public String pGroups = "last, only";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        this.checkFileExists(new String[]{this.inPath});
        String error = this.checkDockerInstall();
        if (error == null) {
            try {
                File file = new File(this.inPath);
                String inName = file.getName();
                File workspaceFile = file.getParentFile();
                String workspace = workspaceFile.getAbsolutePath();
                JSONObject filter = new JSONObject();
                filter.put("type", (Object)"filters.returns");
                filter.put("groups", (Object)this.pGroups);
                String pipelineJson = this.getPipelineJson(inName, this.outName, filter);
                this.pm.message("Running pipeline with filter:");
                this.pm.message(pipelineJson);
                File pipelineFile = this.getPipelineFile(workspaceFile, pipelineJson);
                String cmd = "pdal pipeline " + pipelineFile.getName();
                this.startContainer(workspace);
                this.pm.beginTask("Running command...", -1);
                this.execCommand(cmd);
                this.pm.done();
                pipelineFile.delete();
            }
            finally {
                this.closeClient();
            }
        } else {
            this.pm.errorMessage(error);
        }
    }

    public static void main(String[] args) throws Exception {
        PdalFilterReturns i = new PdalFilterReturns();
        i.inPath = "/Users/hydrologis/data/las/EXAMPLE_river.las";
        i.pGroups = "last, only";
        i.outName = "filtered.las";
        i.process();
    }
}

