/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.network.networkattributes.OmsNetworkAttributesBuilder;

@Description(value="Extracts network attributes and the vector network based on a raster network.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Network, Vector, FlowDirectionsTC, GC, OmsDrainDir, OmsGradient, OmsSlope")
@Label(value="HortonMachine/Network")
@Name(value="_extractvectornet")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class NetworkAttributesBuilder
extends HMModel {
    @Description(value="The network raster map.")
    @UI(value="infile_raster")
    @In
    public String inNet = null;
    @Description(value="The map of flowdirections.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The map of tca.")
    @UI(value="infile_raster")
    @In
    public String inTca = null;
    @Description(value="Flag to also create the hack map.")
    @In
    public boolean doHack = false;
    @Description(value="The vector of the network.")
    @UI(value="outfile")
    @In
    public String outNet = null;
    @Description(value="The map of hack numbering.")
    @UI(value="outfile")
    @In
    public String outHack = null;

    @Execute
    public void process() throws Exception {
        OmsNetworkAttributesBuilder networkattributesbuilder = new OmsNetworkAttributesBuilder();
        networkattributesbuilder.inNet = this.getRaster(this.inNet);
        networkattributesbuilder.inFlow = this.getRaster(this.inFlow);
        networkattributesbuilder.inTca = this.getRaster(this.inTca);
        networkattributesbuilder.doHack = this.doHack;
        networkattributesbuilder.pm = this.pm;
        networkattributesbuilder.doProcess = this.doProcess;
        networkattributesbuilder.doReset = this.doReset;
        networkattributesbuilder.process();
        this.dumpVector(networkattributesbuilder.outNet, this.outNet);
        this.dumpRaster(networkattributesbuilder.outHack, this.outHack);
    }
}

