/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.lwrecruitment.OmsLW05_BridgesDamsWidthAdder;

@Description(value="Correct the bankfull width of the sections of the channels where a bridge or a check dam is found, set the attribute with the origin of the width to the corresponding value.")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="network, vector, point, bankflull, width")
@Label(value="HortonMachine/Hydro-Geomorphology/LWRecruitment")
@Name(value="lw05_bridgesdamswidthadder")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LW05_BridgesDamsWidthAdder
extends HMModel {
    @Description(value="The input hierarchy point network layer.")
    @UI(value="infile_vector")
    @In
    public String inNetPoints = null;
    @Description(value="The input point layer with the bridges to consider to modify channel width.")
    @UI(value="infile_vector")
    @In
    public String inBridges = null;
    @Description(value="The input point layer with the check dams to consider to modify channel width.")
    @UI(value="infile_vector")
    @In
    public String inDams = null;
    @Description(value="Distance within which a dam is assumed to be on the network.")
    @Unit(value="m")
    @In
    public double pDamsOnNetDistance = 15.0;
    @Description(value="Distance within which a bridge is assumed to be on the network.")
    @Unit(value="m")
    @In
    public double pBridgesOnNetDistance = 15.0;
    @Description(value="Fixed value of the width to assign to the sections where there is a check dam.")
    @Unit(value="m")
    @In
    public double pFixedDamsWidth = 0.1;
    @Description(value="Name of the attribute field of the bridges layer to use as width of the channel under the bridge.")
    @In
    public String fBridgeLenght = "LENGHT";
    @Description(value="The output points network layer with the bankfull width updated with the information of bridges and dams width.")
    @UI(value="outfile")
    @In
    public String outNetPoints = null;
    @Description(value="The output layer containing the points of the structures containing no information of the width.")
    @UI(value="outfile")
    @In
    public String outProblemBridges = null;

    @Execute
    public void process() throws Exception {
        OmsLW05_BridgesDamsWidthAdder m = new OmsLW05_BridgesDamsWidthAdder();
        m.inNetPoints = this.getVector(this.inNetPoints);
        m.inBridges = this.getVector(this.inBridges);
        m.inDams = this.getVector(this.inDams);
        m.pDamsOnNetDistance = this.pDamsOnNetDistance;
        m.pBridgesOnNetDistance = this.pBridgesOnNetDistance;
        m.pFixedDamsWidth = this.pFixedDamsWidth;
        m.fBridgeLenght = this.fBridgeLenght;
        m.pm = this.pm;
        m.process();
        this.dumpVector(m.outNetPoints, this.outNetPoints);
        this.dumpVector(m.outProblemBridges, this.outProblemBridges);
    }
}

