/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.network.networkattributes.OmsNetworkAttributesBuilder;

@Description(value="Simple call to the already existing module NetworkAttributesBuilder to create the vector of the network with hierarchical attributes based on an input raster network.")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Network, Vector, FlowDirectionsTC, GC, OmsDrainDir, OmsGradient, OmsSlope")
@Label(value="HortonMachine/Hydro-Geomorphology/LWRecruitment")
@Name(value="lw02_networkattributesbuilder")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LW02_NetworkAttributesBuilder
extends HMModel {
    @Description(value="The extracted network raster map")
    @UI(value="infile_raster")
    @In
    public String inNet = null;
    @Description(value="The map of flow directions")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The map of Total Contributing Areas")
    @UI(value="infile_raster")
    @In
    public String inTca = null;
    @Description(value="The vector of the network")
    @UI(value="outfile")
    @In
    public String outNet = null;

    @Execute
    public void process() throws Exception {
        OmsNetworkAttributesBuilder networkattributesbuilder = new OmsNetworkAttributesBuilder();
        networkattributesbuilder.inNet = this.getRaster(this.inNet);
        networkattributesbuilder.inFlow = this.getRaster(this.inFlow);
        networkattributesbuilder.inTca = this.getRaster(this.inTca);
        networkattributesbuilder.doHack = false;
        networkattributesbuilder.pm = this.pm;
        networkattributesbuilder.doProcess = this.doProcess;
        networkattributesbuilder.doReset = this.doReset;
        networkattributesbuilder.process();
        this.dumpRaster(networkattributesbuilder.outHack, null);
        this.dumpVector(networkattributesbuilder.outNet, this.outNet);
    }
}

