/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.lwrecruitment.OmsLW01_ChannelPolygonMerger;

@Description(value="Merges the adjacent bankfull polygons in a single geometry for further processing.")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="network, vector, union")
@Label(value="HortonMachine/Hydro-Geomorphology/LWRecruitment")
@Name(value="lw01_channelpolygonmerger")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LW01_ChannelPolygonMerger
extends HMModel {
    @Description(value="The input polygon layer of the bankfull area")
    @UI(value="infile_vector")
    @In
    public String inBankfull = null;
    @Description(value="The output polygon of the bankfull area")
    @UI(value="outfile")
    @In
    public String outBankfull = null;

    @Execute
    public void process() throws Exception {
        OmsLW01_ChannelPolygonMerger m = new OmsLW01_ChannelPolygonMerger();
        m.inBankfull = this.getVector(this.inBankfull);
        m.pm = this.pm;
        m.process();
        this.dumpVector(m.outBankfull, this.outBankfull);
    }
}

