/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.grids.OmsGridsGenerator;

@Description(value="Generates grid of lines or polygons.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Vector, Grid")
@Label(value="Vector Processing")
@Name(value="_gridgenerator")
@Status(value=40)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class GridsGenerator
extends HMModel {
    @Description(value="Optional vector map from which to take the bounds (if supplied, all other bounds related parameter are ignored). This needs pRows and pCols to be defined.")
    @UI(value="infile_vector")
    @In
    public String inVector = null;
    @Description(value="Optional raster map from which to take the bounds (if supplied, all other bounds related parameter are ignored. This needs pRows and pCols to be defined.")
    @UI(value="infile_raster")
    @In
    public String inRaster = null;
    @Description(value="The lower left longitude (needed if no map is supplied).")
    @In
    public double pLon = 0.0;
    @Description(value="The lower left latitude (needed if no map is supplied).")
    @In
    public double pLat = 0.0;
    @Description(value="The optional grid cell width.")
    @In
    public double pWidth = 1.0;
    @Description(value="The optional grid cell height.")
    @In
    public double pHeight = 1.0;
    @Description(value="The number of rows.")
    @In
    public int pRows = 10;
    @Description(value="The number of cols.")
    @In
    public int pCols = 10;
    @Description(value="The vertex spacing to use.")
    @In
    public Double pSpacing = null;
    @Description(value="The output type.")
    @UI(value="combo: polygon,line,point")
    @In
    public String pType = "polygon";
    @Description(value="The code defining the coordinate reference system, composed by authority and code number (ex. EPSG:4328). Applied in the case the file is missing.")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The grid.")
    @UI(value="outfile")
    @In
    public String outMap = null;

    @Execute
    public void process() throws Exception {
        OmsGridsGenerator gridsgenerator = new OmsGridsGenerator();
        gridsgenerator.inVector = this.getVector(this.inVector);
        gridsgenerator.inRaster = this.getRaster(this.inRaster);
        gridsgenerator.pLon = this.pLon;
        gridsgenerator.pLat = this.pLat;
        gridsgenerator.pWidth = this.pWidth;
        gridsgenerator.pHeight = this.pHeight;
        gridsgenerator.pRows = this.pRows;
        gridsgenerator.pCols = this.pCols;
        gridsgenerator.pSpacing = this.pSpacing;
        gridsgenerator.pType = this.pType;
        gridsgenerator.pCode = this.pCode;
        gridsgenerator.pm = this.pm;
        gridsgenerator.doProcess = this.doProcess;
        gridsgenerator.doReset = this.doReset;
        gridsgenerator.process();
        this.dumpVector(gridsgenerator.outMap, this.outMap);
    }
}

