/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import java.io.FilenameFilter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.styling.Style;
import org.hortonmachine.dbs.compat.ASpatialDb;
import org.hortonmachine.dbs.geopackage.hm.GeopackageDb;
import org.hortonmachine.gears.libs.exceptions.ModelsIOException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.spatialite.SpatialDbsImportUtils;
import org.hortonmachine.gears.utils.SldUtilities;
import org.hortonmachine.gears.utils.files.FileUtilities;

@Description(value="Creates a geopackage database for geopaparazzi/smash from a set of shapefiles or adds to an existing one.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="geopaparazzi, vector")
@Label(value="Mobile")
@Name(value="geopaparazzigeopackagecreator")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class GeopaparazziGeopackageCreator
extends HMModel {
    @Description(value="The existing or new geopackage database file.")
    @UI(value="infile_gpap")
    @In
    public String inGeopackage = null;
    @Description(value="The folder of shapefiles to import.")
    @UI(value="infolder")
    @In
    public String inShapefilesFolder = null;
    public static final String THE_GEOPAPARAZZI_DATABASE_FILE = "The existing or new geopackage database file.";
    public static final String DESCRIPTION = "Creates a geopackage database for geopaparazzi/smash from a set of shapefiles or adds to an existing one.";
    public static final String OmsGeopaparazziSpatialiteCreator_LABEL = "Vector Processing";
    public static final String OmsGeopaparazziGeopackageCreator_TAGS = "geopaparazzi, vector";
    public static final String OmsGeopaparazziGeopackageCreator_NAME = "geopaparazzigeopackagecreator";
    public static final String OmsGeopaparazziGeopackageCreator_inShapefilesFolder = "The folder of shapefiles to import.";

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inGeopackage, this.inShapefilesFolder});
        File shpFolder = new File(this.inShapefilesFolder);
        File[] shpfiles = shpFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".shp");
            }
        });
        if (shpfiles.length == 0) {
            throw new ModelsIOException("The supplied folder doesn't contain any shapefile.", (Object)this);
        }
        try (GeopackageDb db = new GeopackageDb();){
            if (!db.open(this.inGeopackage)) {
                db.initSpatialMetadata(null);
            }
            this.pm.beginTask("Importing shapefiles...", shpfiles.length);
            for (File shpFile : shpfiles) {
                String name = FileUtilities.getNameWithoutExtention((File)shpFile);
                if (db.hasTable(name)) {
                    this.pm.errorMessage("Table already existing: " + name);
                    continue;
                }
                SpatialDbsImportUtils.createTableFromShp((ASpatialDb)db, (File)shpFile, (String)name, null, (boolean)false);
                SpatialDbsImportUtils.importShapefile((ASpatialDb)db, (File)shpFile, (String)name, (int)-1, (boolean)false, (IHMProgressMonitor)this.pm);
                Style style = SldUtilities.getStyleFromFile((File)shpFile);
                if (style != null) {
                    String sld = SldUtilities.styleToString((Style)style);
                    db.updateSldStyle(name, sld);
                }
                this.pm.worked(1);
            }
            this.pm.done();
        }
    }

    public static void main(String[] args) throws Exception {
        GeopaparazziGeopackageCreator c = new GeopaparazziGeopackageCreator();
        c.inGeopackage = "/Users/hydrologis/Dropbox/hydrologis/data/example_data/naturalearth_italy/ne.gpkg";
        c.inShapefilesFolder = "/Users/hydrologis/Dropbox/hydrologis/data/example_data/naturalearth_italy/";
        c.process();
    }
}

