/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.hmachine.modules.geomorphology.geomorphon.OmsGeomorphon;

@Description(value="The Geomorphon method for rasters")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="raster, geomorphon")
@Label(value="HortonMachine/Geomorphology")
@Name(value="geomorphonraster")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class Geomorphon
extends OmsGeomorphon {
    @Description(value="An elevation raster.")
    @UI(value="infile_raster")
    @In
    public String inElev;
    @Description(value="Maximum search radius")
    @Unit(value="m")
    @In
    public double pRadius;
    @Description(value="Vertical angle threshold.")
    @Unit(value="degree")
    @In
    public double pThreshold = 1.0;
    @Description(value="Output categories raster.")
    @UI(value="outfile")
    @In
    public String outRaster;

    @Execute
    public void process() throws Exception {
        OmsGeomorphon geomorphon = new OmsGeomorphon();
        geomorphon.inElev = this.getRaster(this.inElev);
        geomorphon.pRadius = this.pRadius;
        geomorphon.pThreshold = this.pThreshold;
        geomorphon.pm = this.pm;
        geomorphon.process();
        this.dumpRaster(geomorphon.outRaster, this.outRaster);
    }
}

