/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.geomorphology.flow.OmsFlowDirections;

@Description(value="Calculates the drainage directions with the D8 method.")
@Author(name="David Tarboton, Andrea Antonello", contact="http://www.neng.usu.edu/cee/faculty/dtarb/tardem.html#programs, http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Geomorphology, OmsAspect")
@Label(value="HortonMachine/Geomorphology")
@Name(value="_flow")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class FlowDirections
extends HMModel {
    @Description(value="The depitted elevation map.")
    @UI(value="infile_raster")
    @In
    public String inPit = null;
    @Description(value="The map of flowdirections.")
    @UI(value="outfile")
    @In
    public String outFlow = null;

    @Execute
    public void process() throws Exception {
        OmsFlowDirections omsflowdirections = new OmsFlowDirections();
        omsflowdirections.inPit = this.getRaster(this.inPit);
        omsflowdirections.pm = this.pm;
        omsflowdirections.doProcess = this.doProcess;
        omsflowdirections.doReset = this.doReset;
        omsflowdirections.process();
        this.dumpRaster(omsflowdirections.outFlow, this.outFlow);
    }
}

