/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.network.extractnetwork.OmsExtractNetwork;

@Description(value="Extracts the raster network from an elevation model.")
@Author(name="Andrea Antonello, Franceschi Silvia, Erica Ghesla, Andrea Cozzini, Silvano Pisoni", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Network, Vector, FlowDirectionsTC, GC, OmsDrainDir, OmsGradient, OmsSlope")
@Label(value="HortonMachine/Network")
@Name(value="_extractnet")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class ExtractNetwork
extends HMModel {
    @Description(value="The map of total contributing areas.")
    @UI(value="infile_raster")
    @In
    public String inTca = null;
    @Description(value="The optional map of flowdirections (needed for case with slope or topographic classes).")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The optional map of slope.")
    @UI(value="infile_raster")
    @In
    public String inSlope = null;
    @Description(value="The optional map of aggregated topographic classes.")
    @UI(value="infile_raster")
    @In
    public String inTc3 = null;
    @Description(value="The threshold on the map.")
    @In
    public int pThres = 0;
    @Description(value="The thresholding mode (default is on tca).")
    @UI(value="combo:only tca,tca and slope,tca in convergent sites")
    @In
    public String pMode = "only tca";
    @Description(value="OmsTca exponent for the mode with slope or topographic classes (default = 0.5).")
    @In
    public double pExp = 0.5;
    @Description(value="The extracted network raster.")
    @UI(value="outfile")
    @In
    public String outNet = null;

    @Execute
    public void process() throws Exception {
        OmsExtractNetwork extractnetwork = new OmsExtractNetwork();
        extractnetwork.inTca = this.getRaster(this.inTca);
        extractnetwork.inFlow = this.getRaster(this.inFlow);
        extractnetwork.inSlope = this.getRaster(this.inSlope);
        extractnetwork.inTc3 = this.getRaster(this.inTc3);
        extractnetwork.pThres = this.pThres;
        extractnetwork.pMode = this.pMode;
        extractnetwork.pExp = this.pExp;
        extractnetwork.pm = this.pm;
        extractnetwork.doProcess = this.doProcess;
        extractnetwork.doReset = this.doReset;
        extractnetwork.process();
        this.dumpRaster(extractnetwork.outNet, this.outNet);
    }
}

