/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.io.eicalculator.OmsEIAltimetryWriter;
import org.hortonmachine.gears.io.eicalculator.OmsEIAreasWriter;
import org.hortonmachine.gears.io.eicalculator.OmsEIEnergyWriter;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.energyindexcalculator.OmsEnergyIndexCalculator;

@Description(value="The Adige model.")
@Author(name="Stefano Endrizzi, Silvia Franceschi, Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Hydrology, Energy")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="_eicalculator")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class EnergyIndexCalculator
extends HMModel {
    @Description(value="The digital elevation model (DEM).")
    @UI(value="infile_raster")
    @In
    public String inElev = null;
    @Description(value="The map of subbasins with the id as category.")
    @UI(value="infile_raster")
    @In
    public String inBasins = null;
    @Description(value="The map of curvatures [nabla classes].")
    @UI(value="infile_raster")
    @In
    public String inCurvatures = null;
    @Description(value="The map of aspect in radiants.")
    @UI(value="infile_raster")
    @In
    public String inAspect = null;
    @Description(value="The map of slope in radiants.")
    @UI(value="infile_raster")
    @In
    public String inSlope = null;
    @Description(value="Number of altimetric bands.")
    @In
    public int pEs = -1;
    @Description(value="Number of energetic bands.")
    @In
    public int pEi = -1;
    @Description(value="Aggregation interval of the data [h].")
    @In
    public double pDt = -1.0;
    @Description(value="Output list of altimetric bands information.")
    @UI(value="outfile")
    @In
    public String outAltimetry;
    @Description(value="Output list of energetic bands information.")
    @UI(value="outfile")
    @In
    public String outEnergy;
    @Description(value="Output list of areas of the energetic and altimetric bands.")
    @UI(value="outfile")
    @In
    public String outArea;

    @Execute
    public void process() throws Exception {
        OmsEnergyIndexCalculator energyindexcalculator = new OmsEnergyIndexCalculator();
        energyindexcalculator.inElev = this.getRaster(this.inElev);
        energyindexcalculator.inBasins = this.getRaster(this.inBasins);
        energyindexcalculator.inCurvatures = this.getRaster(this.inCurvatures);
        energyindexcalculator.inAspect = this.getRaster(this.inAspect);
        energyindexcalculator.inSlope = this.getRaster(this.inSlope);
        energyindexcalculator.pEs = this.pEs;
        energyindexcalculator.pEi = this.pEi;
        energyindexcalculator.pDt = this.pDt;
        energyindexcalculator.pm = this.pm;
        energyindexcalculator.process();
        List outAltimetryObj = energyindexcalculator.outAltimetry;
        List outEnergyObj = energyindexcalculator.outEnergy;
        List outAreaObj = energyindexcalculator.outArea;
        OmsEIAltimetryWriter altimetryWriter = new OmsEIAltimetryWriter();
        altimetryWriter.inAltimetry = outAltimetryObj;
        altimetryWriter.file = this.outAltimetry;
        altimetryWriter.write();
        altimetryWriter.close();
        OmsEIEnergyWriter energyWriter = new OmsEIEnergyWriter();
        energyWriter.inEnergy = outEnergyObj;
        energyWriter.file = this.outEnergy;
        energyWriter.write();
        energyWriter.close();
        OmsEIAreasWriter areasWriter = new OmsEIAreasWriter();
        areasWriter.inAreas = outAreaObj;
        areasWriter.file = this.outArea;
        areasWriter.write();
        areasWriter.close();
    }
}

