/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Bibliography;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.connectivity.OmsDownSlopeConnectivity;

@Description(value="Module for the calculation of the downslope connectivity.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="connectivity, raster")
@Label(value="HortonMachine/Hillslope")
@Name(value="_downslopeconnectivity")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
@Bibliography(value={"Geomorphometric assessment of spatial sediment connectivity in small Alpine catchments. - Cavalli et al. 2012"})
public class DownSlopeConnectivity
extends HMModel {
    @Description(value="The map of flowdirections.")
    @UI(value="infile_raster")
    @In
    public String inFlow;
    @Description(value="The network map.")
    @UI(value="infile_raster")
    @In
    public String inNet;
    @Description(value="The map of slope.")
    @UI(value="infile_raster")
    @Unit(value="m/m")
    @In
    public String inSlope;
    @Description(value="The optional map of weights.")
    @UI(value="infile_raster")
    @In
    public String inWeights;
    @Description(value="The optional constant value of weights.")
    @In
    public Double pWeight;
    @Description(value="The connectivity map.")
    @UI(value="outfile")
    @In
    public String outConnectivity = null;

    @Execute
    public void process() throws Exception {
        OmsDownSlopeConnectivity odsc = new OmsDownSlopeConnectivity();
        odsc.inFlow = this.getRaster(this.inFlow);
        odsc.inNet = this.getRaster(this.inNet);
        odsc.inSlope = this.getRaster(this.inSlope);
        odsc.inWeights = this.getRaster(this.inWeights);
        odsc.pWeight = this.pWeight;
        odsc.process();
        this.dumpRaster(odsc.outConnectivity, this.outConnectivity);
    }
}

