/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.demmanipulation.pitfiller.OmsDePitter;

@Description(value="The module fills the depression points present within a DEM and generates a map of flowdirections that also handles flat areas.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="http://www.hydrologis.com")
@Keywords(value="Dem manipulation, Geomorphology")
@Label(value="HortonMachine/Dem Manipulation")
@Name(value="_depit")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class DePitter
extends HMModel {
    @Description(value="The map of digital elevation model (DEM).")
    @UI(value="infile_raster")
    @In
    public String inElev;
    @Description(value="The depitted elevation map.")
    @UI(value="outfile")
    @In
    public String outPit = null;
    @Description(value="The map of D8 flowdirections.")
    @UI(value="outfile")
    @In
    public String outFlow = null;
    public boolean doParallel = true;

    @Execute
    public void process() throws Exception {
        OmsDePitter pitfiller = new OmsDePitter();
        pitfiller.inElev = this.getRaster(this.inElev);
        pitfiller.pm = this.pm;
        pitfiller.doProcess = this.doProcess;
        pitfiller.doReset = this.doReset;
        pitfiller.doParallel = this.doParallel;
        pitfiller.doFlow = this.outFlow != null;
        pitfiller.process();
        if (this.outPit != null) {
            this.dumpRaster(pitfiller.outPit, this.outPit);
        }
        if (this.outFlow != null) {
            this.dumpRaster(pitfiller.outFlow, this.outFlow);
        }
    }

    public static void main(String[] args) throws Exception {
        DePitter d = new DePitter();
        d.inElev = "/Users/hydrologis/Dropbox/hydrologis/lavori/2020_klab/hydrology/INVEST/testGura/DEM_gura.tif";
        d.outPit = "/Users/hydrologis/Dropbox/hydrologis/lavori/2020_klab/hydrology/INVEST/testGura/evapotranspiration_toni/depit_gura.tif";
        d.outFlow = "/Users/hydrologis/Dropbox/hydrologis/lavori/2020_klab/hydrology/INVEST/testGura/evapotranspiration_toni/deflow_gura.tif";
        d.doParallel = true;
        d.process();
    }
}

