/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.carver.OmsCarver;

@Description(value="Carves a raster using a vector map.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Carve, Raster")
@Label(value="Raster Processing")
@Name(value="_carver")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class Carver
extends HMModel {
    @Description(value="The input raster.")
    @UI(value="infile_raster")
    @In
    public String inRaster = null;
    @Description(value="The polygon vector map used to carve the raster.")
    @UI(value="infile_vector")
    @In
    public String inCarverPolygons = null;
    @Description(value="The lines vector map used to carve the raster.")
    @UI(value="infile_vector")
    @In
    public String inCarverLines = null;
    @Description(value="The optional vector lines field containing the depth to be carved.")
    @In
    public String fDepthLines = null;
    @Description(value="The carve depth to use for vector lines if no field is supplied.")
    @In
    public double pDepthLines = 6.0;
    @Description(value="The optional vector polygons field containing the depth to be carved.")
    @In
    public String fDepthPolygons = null;
    @Description(value="The carve depth to use for vector polygons if no field is supplied.")
    @In
    public double pDepthPolygons = 6.0;
    @Description(value="The carved raster map.")
    @UI(value="outfile")
    @In
    public String outRaster = null;

    @Execute
    public void process() throws Exception {
        OmsCarver carver = new OmsCarver();
        carver.pm = this.pm;
        carver.inRaster = this.getRaster(this.inRaster);
        carver.inCarverPolygons = this.getVector(this.inCarverPolygons);
        carver.inCarverLines = this.getVector(this.inCarverLines);
        carver.fDepthLines = this.fDepthLines;
        carver.pDepthLines = this.pDepthLines;
        carver.fDepthPolygons = this.fDepthPolygons;
        carver.pDepthPolygons = this.pDepthPolygons;
        carver.process();
        this.dumpRaster(carver.outRaster, this.outRaster);
    }
}

