/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import org.hornetq.ra.HornetQRALogger;
import org.hornetq.ra.HornetQRAMessageProducer;
import org.hornetq.ra.HornetQRASession;

public class HornetQRAQueueSender
extends HornetQRAMessageProducer
implements QueueSender {
    private static boolean trace = HornetQRALogger.LOGGER.isTraceEnabled();

    public HornetQRAQueueSender(QueueSender producer, HornetQRASession session) {
        super((MessageProducer)producer, session);
        if (trace) {
            HornetQRALogger.LOGGER.trace("constructor(" + producer + ", " + session + ")");
        }
    }

    public Queue getQueue() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getQueue()");
        }
        return ((QueueSender)this.producer).getQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Queue destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                HornetQRALogger.LOGGER.trace("send " + this + " destination=" + destination + " message=" + message + " deliveryMode=" + deliveryMode + " priority=" + priority + " ttl=" + timeToLive);
            }
            this.checkState();
            this.producer.send((Destination)destination, message, deliveryMode, priority, timeToLive);
            if (trace) {
                HornetQRALogger.LOGGER.trace("sent " + this + " result=" + message);
            }
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Queue destination, Message message) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                HornetQRALogger.LOGGER.trace("send " + this + " destination=" + destination + " message=" + message);
            }
            this.checkState();
            this.producer.send((Destination)destination, message);
            if (trace) {
                HornetQRALogger.LOGGER.trace("sent " + this + " result=" + message);
            }
        }
        finally {
            this.session.unlock();
        }
    }
}

