/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.hornetq.ra.HornetQRAConnectionRequestInfo;
import org.hornetq.ra.HornetQRALogger;

public class HornetQRACredential
implements Serializable {
    static final long serialVersionUID = 210476602237497193L;
    private static boolean trace = HornetQRALogger.LOGGER.isTraceEnabled();
    private String userName;
    private String password;

    private HornetQRACredential() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("constructor()");
        }
    }

    public String getUserName() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getUserName()");
        }
        return this.userName;
    }

    private void setUserName(String userName) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setUserName(" + userName + ")");
        }
        this.userName = userName;
    }

    public String getPassword() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getPassword()");
        }
        return this.password;
    }

    private void setPassword(String password) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setPassword(****)");
        }
        this.password = password;
    }

    public static HornetQRACredential getCredential(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info) throws SecurityException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getCredential(" + mcf + ", " + subject + ", " + info + ")");
        }
        HornetQRACredential jc = new HornetQRACredential();
        if (subject == null && info != null) {
            jc.setUserName(((HornetQRAConnectionRequestInfo)info).getUserName());
            jc.setPassword(((HornetQRAConnectionRequestInfo)info).getPassword());
        } else if (subject != null) {
            PasswordCredential pwdc = GetCredentialAction.getCredential(subject, mcf);
            if (pwdc == null) {
                throw new SecurityException("No password credentials found");
            }
            jc.setUserName(pwdc.getUserName());
            jc.setPassword(new String(pwdc.getPassword()));
        } else {
            throw new SecurityException("No Subject or ConnectionRequestInfo set, could not get credentials");
        }
        return jc;
    }

    public String toString() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("toString()");
        }
        return super.toString() + "{ username=" + this.userName + ", password=**** }";
    }

    private static class GetCredentialAction
    implements PrivilegedAction<PasswordCredential> {
        private final Subject subject;
        private final ManagedConnectionFactory mcf;

        GetCredentialAction(Subject subject, ManagedConnectionFactory mcf) {
            if (trace) {
                HornetQRALogger.LOGGER.trace("constructor(" + subject + ", " + mcf + ")");
            }
            this.subject = subject;
            this.mcf = mcf;
        }

        @Override
        public PasswordCredential run() {
            if (trace) {
                HornetQRALogger.LOGGER.trace("run()");
            }
            Set<PasswordCredential> creds = this.subject.getPrivateCredentials(PasswordCredential.class);
            PasswordCredential pwdc = null;
            for (PasswordCredential curCred : creds) {
                if (!curCred.getManagedConnectionFactory().equals(this.mcf)) continue;
                pwdc = curCred;
                break;
            }
            return pwdc;
        }

        static PasswordCredential getCredential(Subject subject, ManagedConnectionFactory mcf) {
            if (trace) {
                HornetQRALogger.LOGGER.trace("getCredential(" + subject + ", " + mcf + ")");
            }
            GetCredentialAction action = new GetCredentialAction(subject, mcf);
            return AccessController.doPrivileged(action);
        }
    }
}

