/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server;

import java.io.Serializable;
import javax.management.ObjectName;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.jms.server.HornetQJMSServerLogger;
import org.hornetq.jms.server.recovery.XARecoveryConfig;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.w3c.dom.Node;

public class HornetQJMSServerLogger_$logger
extends DelegatingBasicLogger
implements Serializable,
HornetQJMSServerLogger,
BasicLogger {
    private static final long serialVersionUID = 1L;
    private static final String projectCode = "HQ";
    private static final String FQCN = HornetQJMSServerLogger_$logger.class.getName();
    private static final String bridgeReconnected = "JMS Bridge Succeeded in reconnecting to servers";
    private static final String jndiUnbindError = "error unbinding {0} from JNDI";
    private static final String noQueueOnTopic = "Queue {0} does not exist on the topic {1}. It was deleted manually probably.";
    private static final String xaRecoveryError = "Error in XA Recovery";
    private static final String failedToCorrectHost = "Tried to correct invalid \"host\" value \"0.0.0.0\" for \"{0}\" connector, but received an exception.";
    private static final String errorUnregisteringBridge = "Failed to unregisted JMS Bridge {0}";
    private static final String bridgeAckError = "JMS Bridge failed to send + acknowledge batch, closing JMS objects";
    private static final String jmsServerError = "JMS Server Manager error";
    private static final String xaRecoverConnectionError = "Notified of connection failure in xa recovery connectionFactory for provider {0} will attempt reconnect on next pass";
    private static final String bridgeRetry = "JMS Bridge Will retry after a pause of {0} ms";
    private static final String bridgeFailure = "Detected failure on bridge connection";
    private static final String jmsDeployerStartError = "Failed to start JMS deployer";
    private static final String xaRecoverError = "Error in XA Recovery recover";
    private static final String failedToSetUpBridge = "Failed to set up JMS bridge connections. Most probably the source or target servers are unavailable. Will retry after a pause of {0} ms";
    private static final String invalidHostForConnector = "Invalid \"host\" value \"0.0.0.0\" detected for \"{0}\" connector. Switching to \"{1}\". If this new address is incorrect please manually configure the connector to use the proper one.";
    private static final String bridgeConnectError = "Failed to connect JMS Bridge";
    private static final String serverCachingCommand = "JMS Server Manager Caching command for {0} since the JMS Server is not active yet";
    private static final String recoveryConnectFailed = "XA Recovery can not connect to any hornetq server on recovery {0}";
    private static final String xaRecoveryStartError = "Could not start recovery discovery on {0}, we will retry every recovery scan until the server is available";
    private static final String xaRecoverAutoConnectionError = "Can not connect to {0} on auto-generated resource recovery";
    private static final String jmsConfigMissingKey = "key attribute missing for JMS configuration {0}";
    private static final String errorStartingBridge = "Failed to start JMS Bridge";
    private static final String bridgeConnected = "Succeeded in connecting to servers";
    private static final String errorConnectingBridge = "JMS Bridge unable to set up connections, bridge will be stopped";
    private static final String jmsBridgeSrcConnectError = "Failed to start source connection";
    private static final String bridgeNotStarted = "JMS Bridge unable to set up connections, bridge will not be started";
    private static final String serverRunningCachedCommand = "JMS Server Manager Running cached command for {0}";
    private static final String errorBridgeAlreadyStarted = "Attempt to start JMS Bridge, but is already started";

    public HornetQJMSServerLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void bridgeReconnected() {
        this.log.logv(FQCN, Logger.Level.INFO, null, "HQ121001: " + this.bridgeReconnected$str(), new Object[0]);
    }

    protected String bridgeReconnected$str() {
        return bridgeReconnected;
    }

    @Override
    public final void jndiUnbindError(Exception e, String key) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ122011: " + this.jndiUnbindError$str(), (Object)key);
    }

    protected String jndiUnbindError$str() {
        return jndiUnbindError;
    }

    @Override
    public final void noQueueOnTopic(String queueName, String name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, "HQ122007: " + this.noQueueOnTopic$str(), (Object)queueName, (Object)name);
    }

    protected String noQueueOnTopic$str() {
        return noQueueOnTopic;
    }

    @Override
    public final void xaRecoveryError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ122016: " + this.xaRecoveryError$str(), new Object[0]);
    }

    protected String xaRecoveryError$str() {
        return xaRecoveryError;
    }

    @Override
    public final void failedToCorrectHost(Exception e, String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ122017: " + this.failedToCorrectHost$str(), (Object)name);
    }

    protected String failedToCorrectHost$str() {
        return failedToCorrectHost;
    }

    @Override
    public final void errorUnregisteringBridge(ObjectName objectName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, "HQ122002: " + this.errorUnregisteringBridge$str(), (Object)objectName);
    }

    protected String errorUnregisteringBridge$str() {
        return errorUnregisteringBridge;
    }

    @Override
    public final void bridgeAckError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ122009: " + this.bridgeAckError$str(), new Object[0]);
    }

    protected String bridgeAckError$str() {
        return bridgeAckError;
    }

    @Override
    public final void jmsServerError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ122012: " + this.jmsServerError$str(), new Object[0]);
    }

    protected String jmsServerError$str() {
        return jmsServerError;
    }

    @Override
    public final void xaRecoverConnectionError(Exception e, ClientSessionFactory csf) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ122014: " + this.xaRecoverConnectionError$str(), (Object)csf);
    }

    protected String xaRecoverConnectionError$str() {
        return xaRecoverConnectionError;
    }

    @Override
    public final void bridgeRetry(long failureRetryInterval) {
        this.log.logv(FQCN, Logger.Level.WARN, null, "HQ122004: " + this.bridgeRetry$str(), (Object)failureRetryInterval);
    }

    protected String bridgeRetry$str() {
        return bridgeRetry;
    }

    @Override
    public final void bridgeFailure() {
        this.log.logv(FQCN, Logger.Level.WARN, null, "HQ122006: " + this.bridgeFailure$str(), new Object[0]);
    }

    protected String bridgeFailure$str() {
        return bridgeFailure;
    }

    @Override
    public final void jmsDeployerStartError(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ124002: " + this.jmsDeployerStartError$str(), new Object[0]);
    }

    protected String jmsDeployerStartError$str() {
        return jmsDeployerStartError;
    }

    @Override
    public final void xaRecoverError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ122013: " + this.xaRecoverError$str(), new Object[0]);
    }

    protected String xaRecoverError$str() {
        return xaRecoverError;
    }

    @Override
    public final void failedToSetUpBridge(long failureRetryInterval) {
        this.log.logv(FQCN, Logger.Level.INFO, null, "HQ121000: " + this.failedToSetUpBridge$str(), (Object)failureRetryInterval);
    }

    protected String failedToSetUpBridge$str() {
        return failedToSetUpBridge;
    }

    @Override
    public final void invalidHostForConnector(String name, String newHost) {
        this.log.logv(FQCN, Logger.Level.INFO, null, "HQ121005: " + this.invalidHostForConnector$str(), (Object)name, (Object)newHost);
    }

    protected String invalidHostForConnector$str() {
        return invalidHostForConnector;
    }

    @Override
    public final void bridgeConnectError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, "HQ122010: " + this.bridgeConnectError$str(), new Object[0]);
    }

    protected String bridgeConnectError$str() {
        return bridgeConnectError;
    }

    @Override
    public final void serverCachingCommand(Object runnable) {
        this.log.logv(FQCN, Logger.Level.INFO, null, "HQ121004: " + this.serverCachingCommand$str(), runnable);
    }

    protected String serverCachingCommand$str() {
        return serverCachingCommand;
    }

    @Override
    public final void recoveryConnectFailed(String s) {
        this.log.logv(FQCN, Logger.Level.WARN, null, "HQ122008: " + this.recoveryConnectFailed$str(), (Object)s);
    }

    protected String recoveryConnectFailed$str() {
        return recoveryConnectFailed;
    }

    @Override
    public final void xaRecoveryStartError(XARecoveryConfig e) {
        this.log.logv(FQCN, Logger.Level.WARN, null, "HQ122018: " + this.xaRecoveryStartError$str(), (Object)e);
    }

    protected String xaRecoveryStartError$str() {
        return xaRecoveryStartError;
    }

    @Override
    public final void xaRecoverAutoConnectionError(Throwable e, XARecoveryConfig csf) {
        this.log.logv(FQCN, Logger.Level.WARN, e, "HQ122015: " + this.xaRecoverAutoConnectionError$str(), (Object)csf);
    }

    protected String xaRecoverAutoConnectionError$str() {
        return xaRecoverAutoConnectionError;
    }

    @Override
    public final void jmsConfigMissingKey(Node e) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, "HQ124000: " + this.jmsConfigMissingKey$str(), (Object)e);
    }

    protected String jmsConfigMissingKey$str() {
        return jmsConfigMissingKey;
    }

    @Override
    public final void errorStartingBridge() {
        this.log.logv(FQCN, Logger.Level.WARN, null, "HQ122001: " + this.errorStartingBridge$str(), new Object[0]);
    }

    protected String errorStartingBridge$str() {
        return errorStartingBridge;
    }

    @Override
    public final void bridgeConnected() {
        this.log.logv(FQCN, Logger.Level.INFO, null, "HQ121002: " + this.bridgeConnected$str(), new Object[0]);
    }

    protected String bridgeConnected$str() {
        return bridgeConnected;
    }

    @Override
    public final void errorConnectingBridge() {
        this.log.logv(FQCN, Logger.Level.WARN, null, "HQ122003: " + this.errorConnectingBridge$str(), new Object[0]);
    }

    protected String errorConnectingBridge$str() {
        return errorConnectingBridge;
    }

    @Override
    public final void jmsBridgeSrcConnectError(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, "HQ124001: " + this.jmsBridgeSrcConnectError$str(), new Object[0]);
    }

    protected String jmsBridgeSrcConnectError$str() {
        return jmsBridgeSrcConnectError;
    }

    @Override
    public final void bridgeNotStarted() {
        this.log.logv(FQCN, Logger.Level.WARN, null, "HQ122005: " + this.bridgeNotStarted$str(), new Object[0]);
    }

    protected String bridgeNotStarted$str() {
        return bridgeNotStarted;
    }

    @Override
    public final void serverRunningCachedCommand(Runnable run) {
        this.log.logv(FQCN, Logger.Level.INFO, null, "HQ121003: " + this.serverRunningCachedCommand$str(), (Object)run);
    }

    protected String serverRunningCachedCommand$str() {
        return serverRunningCachedCommand;
    }

    @Override
    public final void errorBridgeAlreadyStarted() {
        this.log.logv(FQCN, Logger.Level.WARN, null, "HQ122000: " + this.errorBridgeAlreadyStarted$str(), new Object[0]);
    }

    protected String errorBridgeAlreadyStarted$str() {
        return errorBridgeAlreadyStarted;
    }
}

