/*
 * Decompiled with CFR 0.152.
 */
package org.holodeckb2b.commons.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TimeZone;

public final class Utils {
    private static final String XML_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXX";

    public static String toXMLDateTime(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat xmlDateFormatter = new SimpleDateFormat(XML_DATETIME_FORMAT);
        xmlDateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return xmlDateFormatter.format(date);
    }

    public static String toXMLDateTime(LocalDateTime timestamp) {
        if (timestamp == null) {
            return null;
        }
        DateTimeFormatter xmlDateFormatter = DateTimeFormatter.ofPattern(XML_DATETIME_FORMAT);
        return timestamp.atZone(ZoneOffset.UTC).format(xmlDateFormatter);
    }

    public static ZonedDateTime parseDateTimeFromXML(String xmlDateTimeString) throws ParseException {
        String[] formatAndC14NValue = Utils.getFormatAndC14N(xmlDateTimeString);
        if (formatAndC14NValue == null) {
            return null;
        }
        if (formatAndC14NValue[0].endsWith("Z")) {
            return ZonedDateTime.parse(formatAndC14NValue[1], DateTimeFormatter.ofPattern(formatAndC14NValue[0]));
        }
        return ZonedDateTime.of(LocalDateTime.parse(formatAndC14NValue[1], DateTimeFormatter.ofPattern(formatAndC14NValue[0])), ZoneId.systemDefault());
    }

    public static Date fromXMLDateTime(String xmlDateTimeString) throws ParseException {
        String[] formatAndC14NValue = Utils.getFormatAndC14N(xmlDateTimeString);
        return formatAndC14NValue != null ? new SimpleDateFormat(formatAndC14NValue[0]).parse(formatAndC14NValue[1]) : null;
    }

    private static String[] getFormatAndC14N(String xmlDateTimeString) {
        int i;
        if (Utils.isNullOrEmpty(xmlDateTimeString)) {
            return null;
        }
        String s = xmlDateTimeString;
        String f = null;
        if (s == null || s.isEmpty()) {
            return null;
        }
        if (s.indexOf("Z") > 0) {
            s = s.replace("Z", "+00:00");
        }
        if ((i = s.indexOf(".")) > 0) {
            int z = Math.max(s.indexOf("+"), s.indexOf("-", s.indexOf("T")));
            z = z == -1 ? s.length() : z;
            int S = Math.min(z - i - 1, 3);
            s = s.substring(0, i + S + 1) + s.substring(z);
            i = s.indexOf(":", i + S + 1);
            f = "yyyy-MM-dd'T'HH:mm:ss." + "SSS".substring(0, S);
            if (i > 0) {
                s = s.substring(0, i) + s.substring(i + 1);
                f = f + "Z";
            }
        } else if (s.length() > 22) {
            s = s.substring(0, 22) + s.substring(23);
            f = "yyyy-MM-dd'T'HH:mm:ssZ";
        } else {
            f = "yyyy-MM-dd'T'HH:mm:ss";
        }
        return new String[]{f, s};
    }

    public static <K, V> K getKeyByValue(Map<K, V> map, String value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot search for null value");
        }
        Map.Entry f = map.entrySet().parallelStream().filter(e -> value.equals(e.getValue())).findFirst().orElse(null);
        return f != null ? (K)f.getKey() : null;
    }

    public static int compareStrings(String s, String p) {
        if (Utils.isNullOrEmpty(s)) {
            if (!Utils.isNullOrEmpty(p)) {
                return 2;
            }
            return -1;
        }
        if (!Utils.isNullOrEmpty(p)) {
            if (s.equals(p)) {
                return 0;
            }
            return -2;
        }
        return 1;
    }

    public static String getValueOrDefault(String value, String defaultValue) {
        return value != null && !value.isEmpty() ? value : defaultValue;
    }

    public static int[] parseIntArray(String csText) {
        if (Utils.isNullOrEmpty(csText)) {
            return null;
        }
        try {
            String[] sIntervals = csText.split(",");
            int[] intervals = new int[sIntervals.length];
            for (int i = 0; i < sIntervals.length; ++i) {
                intervals[i] = Integer.parseInt(sIntervals[i].trim());
            }
            return intervals;
        }
        catch (NumberFormatException nan) {
            return null;
        }
    }

    public static String toCSLString(int[] aInt) {
        StringBuffer txt = new StringBuffer();
        if (aInt != null && aInt.length > 0) {
            txt.append(aInt[0]);
            for (int i = 1; i < aInt.length; ++i) {
                txt.append(',').append(aInt[i]);
            }
        }
        return txt.toString();
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static boolean isNullOrEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static boolean isNullOrEmpty(Iterator<?> i) {
        return i == null || !i.hasNext();
    }

    public static Throwable getRootCause(Throwable t) {
        List<Throwable> exceptionStack = Utils.getCauses(t);
        return exceptionStack.get(exceptionStack.size() - 1);
    }

    public static List<Throwable> getCauses(Throwable t) {
        ArrayList<Throwable> exceptionStack = new ArrayList<Throwable>();
        for (Throwable i = t; i != null; i = i.getCause()) {
            exceptionStack.add(i);
        }
        return exceptionStack;
    }

    public static String getExceptionTrace(Throwable t) {
        return Utils.getExceptionTrace(t, false);
    }

    public static String getExceptionTrace(Throwable t, boolean indent) {
        StringBuffer r = new StringBuffer();
        if (indent) {
            r.append('\t');
        }
        r.append(t.getClass().getSimpleName());
        if (!Utils.isNullOrEmpty(t.getMessage())) {
            r.append(" : ").append(t.getMessage());
        }
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            r.append('\n').append('\t');
            if (indent) {
                r.append('\t');
            }
            r.append("Caused by: ").append(cause.getClass().getSimpleName());
            if (Utils.isNullOrEmpty(cause.getMessage())) continue;
            r.append(" : ").append(cause.getMessage());
        }
        return r.toString();
    }

    public static <T> boolean nullSafeEqual(T o1, T o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static boolean nullSafeEqual(ZonedDateTime t1, ZonedDateTime t2) {
        return t1 == null ? t2 == null : t2 != null && t1.toInstant().equals(t2.toInstant());
    }

    public static boolean nullSafeEqualIgnoreCase(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equalsIgnoreCase(s2);
    }

    public static boolean isValidURI(String uri) {
        boolean isValid;
        try {
            URI parsedURI = new URI(uri);
            isValid = !Utils.isNullOrEmpty(parsedURI.getScheme());
        }
        catch (URISyntaxException ex) {
            isValid = false;
        }
        return isValid;
    }

    public static boolean isTrue(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("t") || value.equals("1") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("y"));
    }

    public static boolean isTrue(Boolean value) {
        return value != null ? value : false;
    }

    public static long copyStream(InputStream src, OutputStream dst) throws IOException {
        return Utils.copyStream(src, dst, 64);
    }

    public static long copyStream(InputStream src, OutputStream dst, int bufferSize) throws IOException {
        int r;
        long copied = 0L;
        byte[] buffer = new byte[bufferSize];
        while ((r = src.read(buffer)) > 0) {
            dst.write(buffer, 0, r);
            copied += (long)r;
        }
        dst.flush();
        return copied;
    }

    public static <T> T getFirstAvailableProvider(Class<T> providerClass) {
        T provider = null;
        Iterator<T> providers = ServiceLoader.load(providerClass).iterator();
        while (provider == null && providers.hasNext()) {
            try {
                provider = providers.next();
            }
            catch (Throwable throwable) {}
        }
        return provider;
    }

    public static void requireNotNullOrEmpty(String s) {
        if (Utils.isNullOrEmpty(s)) {
            throw new IllegalArgumentException();
        }
    }

    public static void requireNotNullOrEmpty(Collection<?> c) {
        if (Utils.isNullOrEmpty(c)) {
            throw new IllegalArgumentException();
        }
    }

    public static void requireNotNullOrEmpty(Map<?, ?> m) {
        if (Utils.isNullOrEmpty(m)) {
            throw new IllegalArgumentException();
        }
    }

    public static void requireNotNullOrEmpty(Iterator<?> i) {
        if (Utils.isNullOrEmpty(i)) {
            throw new IllegalArgumentException();
        }
    }

    public static boolean areEqual(List<?> l1, List<?> l2) {
        if (l1 == l2) {
            return true;
        }
        if (Utils.isNullOrEmpty(l1) & Utils.isNullOrEmpty(l2)) {
            return true;
        }
        if (l1 == null || l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            Object o2;
            Object o1 = l1.get(i);
            if (o1 == (o2 = l2.get(i)) || o1 != null && o1.equals(o2) && o2 != null && o2.equals(o1)) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(Collection<?> c1, Collection<?> c2) {
        if (c1 == c2) {
            return true;
        }
        if (Utils.isNullOrEmpty(c1) & Utils.isNullOrEmpty(c2)) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        Map<Object, Integer> card1 = Utils.getCardinalities(c1);
        Map<Object, Integer> card2 = Utils.getCardinalities(c2);
        for (Object o1 : c1) {
            if (card1.get(o1) == card2.get(o1)) continue;
            return false;
        }
        return true;
    }

    private static Map<Object, Integer> getCardinalities(Collection<?> c) {
        HashMap<Object, Integer> card = new HashMap<Object, Integer>(c.size());
        for (Object o : c) {
            Integer cc = card.get(o);
            cc = cc != null ? cc + 1 : 1;
            card.put(o, cc);
        }
        return card;
    }
}

