/*
 * Decompiled with CFR 0.152.
 */
package org.holodeckb2b.commons.security;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import org.holodeckb2b.commons.security.CertificateUtils;
import org.holodeckb2b.commons.util.Utils;

public final class KeystoreUtils {
    private static final byte[] JKS_MAGIC_NO = new byte[]{-2, -19, -2, -19};
    private static final byte[] JCEKS_MAGIC_NO = new byte[]{-50, -50, -50, -50};

    public static KeyStore.PrivateKeyEntry readKeyPairFromPKCS12(Path pkcs12File, String pkcs12Password) throws CertificateException {
        KeyStore.PrivateKeyEntry privateKeyEntry;
        FileInputStream fis = new FileInputStream(pkcs12File.toFile());
        try {
            privateKeyEntry = KeystoreUtils.readKeyPairFromKeystore(fis, pkcs12Password);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new CertificateException("Cannot load PKCS#12 file [" + pkcs12File + "]!", ex);
            }
        }
        fis.close();
        return privateKeyEntry;
    }

    public static KeyStore.PrivateKeyEntry readKeyPairFromKeystore(InputStream is, String password) throws CertificateException {
        try {
            KeyStore keyStore = KeystoreUtils.load(is, password);
            String kpAlias = KeystoreUtils.getSingleKPAlias(keyStore);
            char[] pwd = !Utils.isNullOrEmpty(password) ? password.toCharArray() : new char[]{};
            return (KeyStore.PrivateKeyEntry)keyStore.getEntry(kpAlias, new KeyStore.PasswordProtection(pwd));
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException ex) {
            throw new CertificateException("Cannot load key pair from specified key store", ex);
        }
    }

    public static void saveKeyPairToPKCS12(KeyStore.PrivateKeyEntry pk, OutputStream os, String password) throws CertificateException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeystoreType.PKCS12.name());
            keyStore.load(null, null);
            char[] pwd = !Utils.isNullOrEmpty(password) ? password.toCharArray() : new char[]{};
            String alias = CertificateUtils.getSubjectCN((X509Certificate)pk.getCertificate());
            keyStore.setEntry(!Utils.isNullOrEmpty(alias) ? alias : "1", pk, new KeyStore.PasswordProtection(pwd));
            keyStore.store(os, pwd);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw new CertificateException("Could not write the key pair to output stream", ex);
        }
    }

    public static String getKeyPairAliasFromPKCS12(Path pkcs12File, String pkcs12Password) throws CertificateException {
        try {
            KeyStore keyStore = KeystoreUtils.load(KeystoreType.PKCS12, pkcs12File, pkcs12Password);
            return KeystoreUtils.getSingleKPAlias(keyStore);
        }
        catch (KeyStoreException ex) {
            throw new CertificateException("Cannot load key pair from specified PKCS#12 file [" + pkcs12File + "]!", ex);
        }
    }

    private static String getSingleKPAlias(KeyStore ks) throws KeyStoreException {
        String kpAlias = null;
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String a = aliases.nextElement();
            if (ks.isKeyEntry(a) && kpAlias != null) {
                throw new KeyStoreException("More than one key pair in file!");
            }
            if (!ks.isKeyEntry(a)) continue;
            kpAlias = a;
        }
        return kpAlias;
    }

    public static boolean check(Path path, String pwd) {
        if (!Files.isRegularFile(path, new LinkOption[0]) || !Files.isReadable(path)) {
            return false;
        }
        try {
            KeystoreUtils.load(path, pwd);
            return true;
        }
        catch (KeyStoreException spe) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean check(Path path, String pwd, KeystoreType type) {
        if (!Files.isRegularFile(path, new LinkOption[0])) return false;
        if (!Files.isReadable(path)) {
            return false;
        }
        try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(path.toFile()));){
            fis.mark(8);
            KeystoreType fType = KeystoreUtils.detectStoreType(fis);
            if (fType != type) {
                boolean bl = false;
                return bl;
            }
            fis.reset();
            KeystoreUtils.load(type, fis, pwd);
            boolean bl = true;
            return bl;
        }
        catch (IOException | KeyStoreException spe) {
            return false;
        }
    }

    private static KeystoreType detectStoreType(InputStream is) throws IOException {
        byte[] magicno = new byte[4];
        is.read(magicno);
        return Arrays.equals(JKS_MAGIC_NO, magicno) ? KeystoreType.JKS : (Arrays.equals(JCEKS_MAGIC_NO, magicno) ? KeystoreType.JCEKS : KeystoreType.PKCS12);
    }

    public static KeyStore load(Path path, String password) throws KeyStoreException {
        KeyStore keyStore;
        FileInputStream fis = new FileInputStream(path.toFile());
        try {
            keyStore = KeystoreUtils.load(fis, password);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new KeyStoreException("Can not load the keystore [" + path + "]!", ex);
            }
        }
        fis.close();
        return keyStore;
    }

    public static KeyStore load(InputStream is, String password) throws KeyStoreException {
        InputStream mis = is.markSupported() ? is : new BufferedInputStream(is);
        try {
            mis.mark(8);
            KeystoreType type = KeystoreUtils.detectStoreType(mis);
            mis.reset();
            return KeystoreUtils.load(type, mis, password);
        }
        catch (IOException loadError) {
            throw new KeyStoreException("Can not load the keystore from input stream!", loadError);
        }
    }

    public static KeyStore load(KeystoreType type, Path path, String pwd) throws KeyStoreException {
        KeyStore keyStore;
        FileInputStream fis = new FileInputStream(path.toFile());
        try {
            keyStore = KeystoreUtils.load(type, fis, pwd);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new KeyStoreException("Can not load the keystore [" + path + "]!", ex);
            }
        }
        fis.close();
        return keyStore;
    }

    public static KeyStore load(KeystoreType type, InputStream is, String pwd) throws KeyStoreException {
        try {
            KeyStore keyStore = KeyStore.getInstance(type.name());
            keyStore.load(is, !Utils.isNullOrEmpty(pwd) ? pwd.toCharArray() : new char[]{});
            return keyStore;
        }
        catch (IOException | NullPointerException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw new KeyStoreException("Can not load the keystore from input stream!", ex);
        }
    }

    public static void save(KeyStore keystore, Path path, String pwd) throws KeyStoreException {
        try (FileOutputStream fos = new FileOutputStream(path.toFile());){
            keystore.store(fos, !Utils.isNullOrEmpty(pwd) ? pwd.toCharArray() : new char[]{});
        }
        catch (IOException | NullPointerException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw new KeyStoreException("Can not save the keystore to file [" + path + "]!", ex);
        }
    }

    public static enum KeystoreType {
        JKS,
        JCEKS,
        PKCS12;

    }
}

