/*
 * Decompiled with CFR 0.152.
 */
package org.holodeckb2b.commons.testing;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;

public class TestUtils {
    public static Path getTestResource(String fileName) {
        return TestUtils.getTestClassBasePath().resolve(fileName);
    }

    public static Path getTestClassBasePath() {
        Path clsPath;
        StackTraceElement[] trace = new Throwable().fillInStackTrace().getStackTrace();
        String clsName = trace[1].getClassName();
        if (TestUtils.class.getName().equals(clsName)) {
            clsName = trace[2].getClassName();
        }
        return (clsPath = TestUtils.getResourcePath(clsName.substring(clsName.lastIndexOf(46) + 1).toLowerCase())) != null ? clsPath : TestUtils.getResourcePath(".");
    }

    private static Path getResourcePath(String file) {
        try {
            URL url = TestUtils.class.getClassLoader().getResource(file);
            return url == null ? null : Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

