/*
 * Decompiled with CFR 0.152.
 */
package org.holodeckb2b.commons.testing;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.holodeckb2b.commons.util.Utils;

public class HttpBackendMock {
    private HttpServer server;
    private int successCode = 202;
    private int rejectionCode = 500;
    private byte[] responseEntityBody = null;
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private int acceptAfter = 0;
    private int attempts = 0;
    private URI requestURL;
    private Map<String, String> requestHeaders;
    private byte[] requestEntityBody;

    public HttpBackendMock(int timeout) throws Exception {
        this.server = HttpServer.create(new InetSocketAddress(0), 0);
        this.server.createContext("/accept", new AcceptHandler());
        this.server.createContext("/reject", new RejectHandler());
        this.server.createContext("/timeout", new TimeoutHandler(timeout));
    }

    public void start() {
        this.server.start();
        System.out.println("[HttpBackendMock] Started at port: " + this.getPort());
    }

    public int getPort() {
        return this.server.getAddress().getPort();
    }

    public void setSuccessCode(int code) {
        this.successCode = code;
    }

    public void setResponseEntityBody(byte[] bytes) {
        this.responseEntityBody = bytes;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setRejectionCode(int code) {
        this.rejectionCode = code;
    }

    public void setMinRetries(int attempts) {
        this.acceptAfter = attempts;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public void resetAttempts() {
        this.attempts = 0;
    }

    public void clearRequests() {
        this.attempts = 0;
        this.requestURL = null;
        this.requestHeaders = null;
        this.requestEntityBody = null;
    }

    public void stop() {
        this.server.stop(0);
    }

    public URI getRequestURL() {
        return this.requestURL;
    }

    public Map<String, String> getRcvdHeaders() {
        return this.requestHeaders;
    }

    public byte[] getRcvdData() {
        return this.requestEntityBody;
    }

    static /* synthetic */ byte[] access$202(HttpBackendMock x0, byte[] x1) {
        x0.requestEntityBody = x1;
        return x1;
    }

    class TimeoutHandler
    extends BaseHandler {
        private int timeout;

        TimeoutHandler(int t) {
            this.timeout = t;
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            super.handle(t);
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            t.sendResponseHeaders(HttpBackendMock.this.successCode, 0L);
            t.close();
        }
    }

    class RejectHandler
    extends BaseHandler {
        RejectHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            super.handle(t);
            t.sendResponseHeaders(HttpBackendMock.this.rejectionCode, 0L);
            t.close();
        }
    }

    class AcceptHandler
    extends BaseHandler {
        AcceptHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            super.handle(t);
            t.sendResponseHeaders(HttpBackendMock.this.attempts > HttpBackendMock.this.acceptAfter ? HttpBackendMock.this.successCode : HttpBackendMock.this.rejectionCode, HttpBackendMock.this.responseEntityBody != null ? (long)HttpBackendMock.this.responseEntityBody.length : 0L);
            if (HttpBackendMock.this.attempts > HttpBackendMock.this.acceptAfter && HttpBackendMock.this.responseEntityBody != null) {
                Utils.copyStream((InputStream)new ByteArrayInputStream(HttpBackendMock.this.responseEntityBody), (OutputStream)t.getResponseBody());
            }
            t.close();
        }
    }

    class BaseHandler
    implements HttpHandler {
        BaseHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            HttpBackendMock.this.requestURL = t.getRequestURI();
            HttpBackendMock.this.requestHeaders = null;
            HttpBackendMock.access$202(HttpBackendMock.this, null);
            System.out.println("[HttpBackendMock] Handling request for URL: " + HttpBackendMock.this.requestURL);
            HttpBackendMock.this.attempts++;
            HttpBackendMock.this.requestHeaders = new HashMap();
            for (Map.Entry<String, List<String>> h : t.getRequestHeaders().entrySet()) {
                String hv = "";
                for (int i = 0; i < h.getValue().size() - 1; ++i) {
                    hv = hv + h.getValue().get(i) + ",";
                }
                hv = hv + h.getValue().get(h.getValue().size() - 1);
                HttpBackendMock.this.requestHeaders.put(h.getKey().toLowerCase(), hv);
            }
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                Utils.copyStream((InputStream)t.getRequestBody(), (OutputStream)bos);
                HttpBackendMock.access$202(HttpBackendMock.this, bos.toByteArray());
            }
            if (HttpBackendMock.this.requestEntityBody.length == 0) {
                HttpBackendMock.access$202(HttpBackendMock.this, null);
            }
            HttpBackendMock.this.responseHeaders.forEach((k, v) -> t.getResponseHeaders().add((String)k, (String)v));
        }
    }
}

