/*
 * Decompiled with CFR 0.152.
 */
package org.hobsoft.hamcrest.compose;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class ConjunctionMatcher<T>
extends TypeSafeDiagnosingMatcher<T> {
    private static final String SEPARATOR = " and ";
    private final String compositeDescription;
    private final List<Matcher<T>> matchers;

    ConjunctionMatcher(String compositeDescription, List<Matcher<T>> matchers) {
        Objects.requireNonNull(matchers, "matchers");
        if (matchers.isEmpty()) {
            throw new IllegalArgumentException("matchers cannot be empty");
        }
        this.compositeDescription = compositeDescription;
        this.matchers = Collections.unmodifiableList(new ArrayList<Matcher<T>>(matchers));
    }

    public static <T> ConjunctionMatcher<T> compose(Matcher<T> matcher) {
        return ConjunctionMatcher.compose(null, matcher);
    }

    public static <T> ConjunctionMatcher<T> compose(String compositeDescription, Matcher<T> matcher) {
        Objects.requireNonNull(matcher, "matcher");
        return new ConjunctionMatcher<T>(compositeDescription, Collections.singletonList(matcher));
    }

    public ConjunctionMatcher<T> and(Matcher<T> matcher) {
        Objects.requireNonNull(matcher, "matcher");
        return new ConjunctionMatcher<T>(this.compositeDescription, ConjunctionMatcher.concat(this.matchers, matcher));
    }

    public void describeTo(Description description) {
        String start = this.compositeDescription != null ? this.compositeDescription + " " : "";
        description.appendList(start, SEPARATOR, "", this.matchers);
    }

    protected boolean matchesSafely(T actual, Description mismatch) {
        boolean matches = true;
        for (Matcher<T> matcher : this.matchers) {
            if (matcher.matches(actual)) continue;
            if (!matches) {
                mismatch.appendText(SEPARATOR);
            }
            matches = false;
            matcher.describeMismatch(actual, mismatch);
        }
        return matches;
    }

    private static <T> List<T> concat(List<T> list, T element) {
        ArrayList<T> newList = new ArrayList<T>(list);
        newList.add(element);
        return newList;
    }
}

