/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim.nonlinear.vector.constrained;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.nonlinear.vector.constrained.TwiceDifferentiableFunction;
import org.hipparchus.util.MathUtils;

public class QuadraticFunction
extends TwiceDifferentiableFunction {
    private final RealMatrix p;
    private final RealVector q;
    private final double d;
    private final int n;

    public QuadraticFunction(RealMatrix p, RealVector q, double d) {
        this.n = q.getDimension();
        if (this.n < 1) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.INSUFFICIENT_DIMENSION, new Object[]{d, 1});
        }
        MathUtils.checkDimension((int)p.getRowDimension(), (int)this.n);
        this.p = p.copy();
        this.q = q.copy();
        this.d = d;
    }

    public QuadraticFunction(double[][] h, double[] c, double d) {
        this((RealMatrix)new Array2DRowRealMatrix(h), (RealVector)new ArrayRealVector(c), d);
    }

    public RealMatrix getP() {
        return this.p;
    }

    public RealVector getQ() {
        return this.q;
    }

    public double getD() {
        return this.d;
    }

    @Override
    public int dim() {
        return this.n;
    }

    @Override
    public double value(RealVector x) {
        return 0.5 * this.p.operate(x).dotProduct(x) + this.q.dotProduct(x) + this.d;
    }

    @Override
    public RealVector gradient(RealVector x) {
        return this.p.operate(x).add(this.q);
    }

    @Override
    public RealMatrix hessian(RealVector x) {
        return this.p.copy();
    }
}

