/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.binder;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.DuplicateMappingException;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.hibernate.tool.api.reveng.TableIdentifier;
import org.hibernate.tool.internal.reveng.RevengMetadataCollector;
import org.hibernate.tool.internal.reveng.binder.AbstractBinder;
import org.hibernate.tool.internal.reveng.binder.BasicPropertyBinder;
import org.hibernate.tool.internal.reveng.binder.BinderContext;
import org.hibernate.tool.internal.reveng.binder.BinderUtils;
import org.hibernate.tool.internal.reveng.binder.ForeignKeyBinder;
import org.hibernate.tool.internal.reveng.binder.PrimaryKeyBinder;
import org.hibernate.tool.internal.reveng.binder.PrimaryKeyInfo;
import org.hibernate.tool.internal.reveng.binder.VersionPropertyBinder;
import org.hibernate.tool.internal.reveng.util.RevengUtils;

public class RootClassBinder
extends AbstractBinder {
    private static final Logger LOGGER = Logger.getLogger(RootClassBinder.class.getName());
    private final PrimaryKeyBinder primaryKeyBinder;
    private final VersionPropertyBinder versionPropertyBinder;
    private final ForeignKeyBinder foreignKeyBinder;
    private final BasicPropertyBinder basicPropertyBinder;

    public static RootClassBinder create(BinderContext binderContext) {
        return new RootClassBinder(binderContext);
    }

    private RootClassBinder(BinderContext binderContext) {
        super(binderContext);
        this.primaryKeyBinder = PrimaryKeyBinder.create(binderContext);
        this.versionPropertyBinder = VersionPropertyBinder.create(binderContext);
        this.foreignKeyBinder = ForeignKeyBinder.create(binderContext);
        this.basicPropertyBinder = BasicPropertyBinder.create(binderContext);
    }

    public void bind(Table table, RevengMetadataCollector revengMetadataCollector) {
        HashSet<Column> processed = new HashSet<Column>();
        this.nullifyDefaultCatalogAndSchema(table);
        RootClass rc = this.createRootClass(table);
        this.addToMetadataCollector(rc, table);
        PrimaryKeyInfo pki = this.bindPrimaryKey(table, rc, processed, revengMetadataCollector);
        this.bindVersionProperty(table, rc, processed);
        this.bindOutgoingForeignKeys(table, rc, processed);
        this.bindColumnsToProperties(table, rc, processed);
        this.bindIncomingForeignKeys((PersistentClass)rc, processed, revengMetadataCollector);
        this.updatePrimaryKey(rc, pki);
    }

    private PrimaryKeyInfo bindPrimaryKey(Table table, RootClass rc, Set<Column> processed, RevengMetadataCollector revengMetadataCollector) {
        return this.primaryKeyBinder.bind(table, rc, processed, revengMetadataCollector);
    }

    private void updatePrimaryKey(RootClass rc, PrimaryKeyInfo pki) {
        this.primaryKeyBinder.updatePrimaryKey(rc, pki);
    }

    private void addToMetadataCollector(RootClass rc, Table table) {
        try {
            this.getMetadataCollector().addEntityBinding((PersistentClass)rc);
            this.getMetadataCollector().addImport(rc.getEntityName(), rc.getEntityName());
        }
        catch (DuplicateMappingException dme) {
            PersistentClass class1 = this.getMetadataCollector().getEntityBinding(dme.getName());
            Table table2 = class1.getTable();
            throw new RuntimeException("Duplicate class name '" + rc.getEntityName() + "' generated for '" + String.valueOf(table) + "'. Same name where generated for '" + String.valueOf(table2) + "'");
        }
    }

    private RootClass createRootClass(Table table) {
        RootClass rc = new RootClass(this.getMetadataBuildingContext());
        TableIdentifier tableIdentifier = TableIdentifier.create(table);
        String className = this.getRevengStrategy().tableToClassName(tableIdentifier);
        LOGGER.log(Level.INFO, "Building entity " + className + " based on " + String.valueOf(tableIdentifier));
        rc.setEntityName(className);
        rc.setJpaEntityName(StringHelper.unqualify((String)className));
        rc.setClassName(className);
        rc.setProxyInterfaceName(rc.getEntityName());
        rc.setLazy(true);
        rc.setMetaAttributes(this.getMetaAttributes(table));
        rc.setDiscriminatorValue(rc.getEntityName());
        rc.setTable(table);
        rc.setOptimisticLockStyle(OptimisticLockStyle.NONE);
        return rc;
    }

    private void nullifyDefaultCatalogAndSchema(Table table) {
        if (table.getCatalog() != null && table.getCatalog().equals(this.getDefaultCatalog())) {
            table.setCatalog(null);
        }
        if (table.getSchema() != null && table.getSchema().equals(this.getDefaultSchema())) {
            table.setSchema(null);
        }
    }

    private void bindVersionProperty(Table table, RootClass rc, Set<Column> processed) {
        this.versionPropertyBinder.bind(table, rc, processed);
    }

    private void bindIncomingForeignKeys(PersistentClass rc, Set<Column> processed, RevengMetadataCollector revengMetadataCollector) {
        List<ForeignKey> foreignKeys = revengMetadataCollector.getOneToManyCandidates().get(rc.getEntityName());
        if (foreignKeys != null) {
            Iterator<ForeignKey> iter = foreignKeys.iterator();
            while (iter.hasNext()) {
                this.foreignKeyBinder.bindIncoming(iter.next(), rc, processed);
            }
        }
    }

    private void bindOutgoingForeignKeys(Table table, RootClass rc, Set<Column> processedColumns) {
        for (ForeignKey foreignKey : table.getForeignKeys().values()) {
            boolean mutable = true;
            if (this.contains(foreignKey.getColumns().iterator(), processedColumns)) {
                if (!this.preferBasicCompositeIds().booleanValue()) continue;
                mutable = false;
            }
            this.foreignKeyBinder.bindOutgoing(foreignKey, table, (PersistentClass)rc, processedColumns, mutable);
        }
    }

    private void bindColumnsToProperties(Table table, RootClass rc, Set<Column> processedColumns) {
        for (Column column : table.getColumns()) {
            if (processedColumns.contains(column)) continue;
            BinderUtils.checkColumnForMultipleBinding(column);
            String propertyName = this.getColumnToPropertyNameInRevengStrategy(table, column);
            Property property = this.basicPropertyBinder.bind(BinderUtils.makeUnique((PersistentClass)rc, propertyName), table, column);
            rc.addProperty(property);
        }
    }

    private boolean contains(Iterator<Column> columnIterator, Set<Column> processedColumns) {
        while (columnIterator.hasNext()) {
            Column element = columnIterator.next();
            if (!processedColumns.contains(element)) continue;
            return true;
        }
        return false;
    }

    private Map<String, MetaAttribute> getMetaAttributes(Table table) {
        Map<String, Object> result = null;
        TableIdentifier tableIdentifier = TableIdentifier.create(table);
        result = this.getRevengStrategy().tableToMetaAttributes(tableIdentifier);
        if (result == null) {
            tableIdentifier = RevengUtils.createTableIdentifier(table, this.getDefaultCatalog(), this.getDefaultSchema());
            result = this.getRevengStrategy().tableToMetaAttributes(tableIdentifier);
        }
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    private String getColumnToPropertyNameInRevengStrategy(Table table, Column column) {
        String result = null;
        String columnName = column.getName();
        TableIdentifier tableIdentifier = TableIdentifier.create(table);
        result = this.getRevengStrategy().columnToPropertyName(tableIdentifier, columnName);
        if (result == null) {
            tableIdentifier = RevengUtils.createTableIdentifier(table, this.getDefaultCatalog(), this.getDefaultSchema());
            result = this.getRevengStrategy().columnToPropertyName(tableIdentifier, columnName);
        }
        return result;
    }
}

