/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.export.common;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Component;
import org.hibernate.tool.internal.export.common.AbstractExporter;
import org.hibernate.tool.internal.export.common.ConfigurationNavigator;
import org.hibernate.tool.internal.export.common.TemplateProducer;
import org.hibernate.tool.internal.export.java.ComponentPOJOClass;
import org.hibernate.tool.internal.export.java.POJOClass;

public class GenericExporter
extends AbstractExporter {
    static Map<String, ModelIterator> modelIterators = new HashMap<String, ModelIterator>();

    protected String getTemplateName() {
        return (String)this.getProperties().get("org.hibernate.tool.api.export.ExporterConstants.TemplateName");
    }

    @Override
    protected void doStart() {
        if (this.getFilePattern() == null) {
            throw new RuntimeException("File pattern not set on " + String.valueOf(this.getClass()));
        }
        if (this.getTemplateName() == null) {
            throw new RuntimeException("Template name not set on " + String.valueOf(this.getClass()));
        }
        ArrayList<ModelIterator> exporters = new ArrayList<ModelIterator>();
        if (StringHelper.isEmpty((String)this.getForEach())) {
            if (this.getFilePattern().indexOf("{class-name}") >= 0) {
                exporters.add(modelIterators.get("entity"));
                exporters.add(modelIterators.get("component"));
            } else {
                exporters.add(modelIterators.get("configuration"));
            }
        } else {
            StringTokenizer tokens = new StringTokenizer(this.getForEach(), ",");
            while (tokens.hasMoreTokens()) {
                String nextToken = tokens.nextToken();
                ModelIterator modelIterator = modelIterators.get(nextToken);
                if (modelIterator == null) {
                    throw new RuntimeException("for-each does not support [" + nextToken + "]");
                }
                exporters.add(modelIterator);
            }
        }
        for (ModelIterator mit : exporters) {
            mit.process(this);
        }
    }

    protected void exportComponent(Map<String, Object> additionalContext, POJOClass element) {
        this.exportPOJO(additionalContext, element);
    }

    protected void exportPersistentClass(Map<String, Object> additionalContext, POJOClass element) {
        this.exportPOJO(additionalContext, element);
    }

    protected void exportPOJO(Map<String, Object> additionalContext, POJOClass element) {
        TemplateProducer producer = new TemplateProducer(this.getTemplateHelper(), this.getArtifactCollector());
        additionalContext.put("pojo", element);
        additionalContext.put("clazz", element.getDecoratedObject());
        String filename = this.resolveFilename(element);
        if (filename.endsWith(".java") && filename.indexOf(36) >= 0) {
            this.log.warn((Object)("Filename for " + this.getClassNameForFile(element) + " contains a $. Innerclass generation is not supported."));
        }
        producer.produce(additionalContext, this.getTemplateName(), new File(this.getOutputDirectory(), filename), this.getTemplateName(), element.toString());
    }

    protected String resolveFilename(POJOClass element) {
        String filename = StringHelper.replace((String)this.getFilePattern(), (String)"{class-name}", (String)this.getClassNameForFile(element));
        String packageLocation = StringHelper.replace((String)this.getPackageNameForFile(element), (String)".", (String)"/");
        if (StringHelper.isEmpty((String)packageLocation)) {
            packageLocation = ".";
        }
        filename = StringHelper.replace((String)filename, (String)"{package-name}", (String)packageLocation);
        return filename;
    }

    protected String getPackageNameForFile(POJOClass element) {
        return element.getPackageName();
    }

    protected String getClassNameForFile(POJOClass element) {
        return element.getDeclarationName();
    }

    private String getFilePattern() {
        return (String)this.getProperties().get("org.hibernate.tool.api.export.ExporterConstants.FilePattern");
    }

    private String getForEach() {
        return (String)this.getProperties().get("org.hibernate.tool.api.export.ExporterConstants.ForEach");
    }

    static {
        modelIterators.put("configuration", new ModelIterator(){

            @Override
            void process(GenericExporter ge) {
                TemplateProducer producer = new TemplateProducer(ge.getTemplateHelper(), ge.getArtifactCollector());
                producer.produce(new HashMap<String, Object>(), ge.getTemplateName(), new File(ge.getOutputDirectory(), ge.getFilePattern()), ge.getTemplateName(), "Configuration");
            }
        });
        modelIterators.put("entity", new ModelIterator(){

            @Override
            void process(GenericExporter ge) {
                Iterator<POJOClass> iterator = ge.getCfg2JavaTool().getPOJOIterator(ge.getMetadata().getEntityBindings().iterator());
                HashMap<String, Object> additionalContext = new HashMap<String, Object>();
                while (iterator.hasNext()) {
                    POJOClass element = iterator.next();
                    ge.exportPersistentClass(additionalContext, element);
                }
            }
        });
        modelIterators.put("component", new ModelIterator(){

            @Override
            void process(GenericExporter ge) {
                HashMap<String, Component> components = new HashMap<String, Component>();
                Iterator<POJOClass> iterator = ge.getCfg2JavaTool().getPOJOIterator(ge.getMetadata().getEntityBindings().iterator());
                HashMap<String, Object> additionalContext = new HashMap<String, Object>();
                while (iterator.hasNext()) {
                    POJOClass element = iterator.next();
                    ConfigurationNavigator.collectComponents(components, element);
                }
                for (Component component : components.values()) {
                    ComponentPOJOClass element = new ComponentPOJOClass(component, ge.getCfg2JavaTool());
                    ge.exportComponent(additionalContext, element);
                }
            }
        });
    }

    static abstract class ModelIterator {
        ModelIterator() {
        }

        abstract void process(GenericExporter var1);
    }
}

