/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.export.lint;

import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.tool.internal.export.lint.EntityModelDetector;
import org.hibernate.tool.internal.export.lint.Issue;
import org.hibernate.tool.internal.export.lint.IssueCollector;

public class ShadowedIdentifierDetector
extends EntityModelDetector {
    @Override
    public String getName() {
        return "shadow-id";
    }

    @Override
    protected void visitProperty(PersistentClass clazz, Property property, IssueCollector collector) {
        if (property.getName().equals("id") && property != property.getPersistentClass().getIdentifierProperty()) {
            collector.reportIssue(new Issue("ID_SHADOWED", 0, property.getPersistentClass().getEntityName() + " has a normal property named 'id'. This can cause issues since HQL queries will always interpret 'id' as the identifier and not the concrete property"));
        }
    }
}

