/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.export.java;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.hibernate.boot.Metadata;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.JoinedList;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.mapping.Value;
import org.hibernate.tool.internal.export.java.BasicPOJOClass;
import org.hibernate.tool.internal.export.java.Cfg2JavaTool;
import org.hibernate.tool.internal.export.java.POJOClass;
import org.hibernate.tool.internal.util.AnnotationBuilder;
import org.hibernate.tool.internal.util.IteratorTransformer;
import org.hibernate.tool.internal.util.SkipBackRefPropertyIterator;
import org.hibernate.type.ForeignKeyDirection;

public class EntityPOJOClass
extends BasicPOJOClass {
    private PersistentClass clazz;

    public EntityPOJOClass(PersistentClass clazz, Cfg2JavaTool cfg) {
        super((MetaAttributable)clazz, cfg);
        this.clazz = clazz;
        this.init();
    }

    @Override
    protected String getMappedClassName() {
        return this.clazz.getClassName();
    }

    @Override
    public String getExtends() {
        Object extendz = "";
        if (this.isInterface()) {
            if (this.clazz.getSuperclass() != null) {
                extendz = this.clazz.getSuperclass().getClassName();
            }
            if (this.clazz.getMetaAttribute("extends") != null) {
                if (!"".equals(extendz)) {
                    extendz = (String)extendz + ",";
                }
                extendz = (String)extendz + this.getMetaAsString("extends", ",");
            }
        } else if (this.clazz.getSuperclass() != null) {
            if (!this.c2j.getPOJOClass(this.clazz.getSuperclass()).isInterface()) {
                extendz = this.clazz.getSuperclass().getClassName();
            }
        } else if (this.clazz.getMetaAttribute("extends") != null) {
            extendz = this.getMetaAsString("extends", ",");
        }
        return "".equals(extendz) ? null : extendz;
    }

    @Override
    public String getImplements() {
        ArrayList<String> interfaces = new ArrayList<String>();
        if (this.clazz.getProxyInterfaceName() != null && !this.clazz.getProxyInterfaceName().equals(this.clazz.getClassName())) {
            interfaces.add(this.clazz.getProxyInterfaceName());
        }
        if (!this.isInterface()) {
            if (this.clazz.getSuperclass() != null && this.c2j.getPOJOClass(this.clazz.getSuperclass()).isInterface()) {
                interfaces.add(this.clazz.getSuperclass().getClassName());
            }
            if (this.clazz.getMetaAttribute("implements") != null) {
                interfaces.addAll(this.clazz.getMetaAttribute("implements").getValues());
            }
            interfaces.add(Serializable.class.getName());
        }
        if (interfaces.size() > 0) {
            StringBuffer sbuf = new StringBuffer();
            Iterator iter = interfaces.iterator();
            while (iter.hasNext()) {
                sbuf.append((String)iter.next());
                if (!iter.hasNext()) continue;
                sbuf.append(",");
            }
            return sbuf.toString();
        }
        return null;
    }

    @Override
    public Iterator<Property> getAllPropertiesIterator() {
        return this.getAllPropertiesIterator(this.clazz);
    }

    public Iterator<Property> getAllPropertiesIterator(PersistentClass pc) {
        ArrayList<Property> properties = new ArrayList<Property>();
        ArrayList<List> lists = new ArrayList<List>();
        if (pc.getSuperclass() == null) {
            if (pc.hasIdentifierProperty()) {
                properties.add(pc.getIdentifierProperty());
            } else if (pc.hasEmbeddedIdentifier()) {
                Component embeddedComponent = (Component)pc.getIdentifier();
                lists.add(embeddedComponent.getProperties());
            }
        }
        List pl = pc.getProperties();
        for (Property element : pl) {
            if (element.getValue() instanceof Component && element.getPropertyAccessorName().equals("embedded")) {
                Component component = (Component)element.getValue();
                List embeddedProperties = component.getProperties();
                for (Property p : embeddedProperties) {
                    properties.add(p);
                }
                continue;
            }
            properties.add(element);
        }
        lists.add(properties);
        return new SkipBackRefPropertyIterator(new JoinedList(lists).iterator());
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public boolean hasIdentifierProperty() {
        return this.clazz.hasIdentifierProperty() && this.clazz instanceof RootClass;
    }

    @Override
    public Property getIdentifierProperty() {
        return this.clazz.getIdentifierProperty();
    }

    @Override
    public String generateAnnTableUniqueConstraint() {
        if (!(this.clazz instanceof Subclass)) {
            Table table = this.clazz.getTable();
            return this.generateAnnTableUniqueConstraint(table);
        }
        return "";
    }

    protected String generateAnnTableUniqueConstraint(Table table) {
        ArrayList<String> cons = new ArrayList<String>();
        for (UniqueKey key : table.getUniqueKeys().values()) {
            if (table.hasPrimaryKey() && table.getPrimaryKey().getColumns().equals(key.getColumns())) continue;
            AnnotationBuilder constraint = AnnotationBuilder.createAnnotation(this.importType("jakarta.persistence.UniqueConstraint"));
            constraint.addQuotedAttributes("columnNames", new IteratorTransformer<Column>(key.getColumns().iterator()){

                @Override
                public String transform(Column column) {
                    return column.getName();
                }
            });
            cons.add(constraint.getResult());
        }
        AnnotationBuilder builder = AnnotationBuilder.createAnnotation("dummyAnnotation");
        builder.addAttributes("dummyAttribute", cons.iterator());
        String attributeAsString = builder.getAttributeAsString("dummyAttribute");
        return attributeAsString == null ? "" : attributeAsString;
    }

    @Override
    public String generateAnnIdGenerator() {
        KeyValue identifier = this.clazz.getIdentifier();
        String strategy = null;
        Properties properties = null;
        StringBuffer wholeString = new StringBuffer("    ");
        if (identifier instanceof Component) {
            wholeString.append(AnnotationBuilder.createAnnotation(this.importType("jakarta.persistence.EmbeddedId")).getResult());
        } else if (identifier instanceof SimpleValue) {
            SimpleValue simpleValue = (SimpleValue)identifier;
            strategy = simpleValue.getIdentifierGeneratorStrategy();
            properties = this.c2j.getFilteredIdentifierGeneratorProperties(simpleValue);
            StringBuffer idResult = new StringBuffer();
            AnnotationBuilder builder = AnnotationBuilder.createAnnotation(this.importType("jakarta.persistence.Id"));
            idResult.append(builder.getResult());
            idResult.append(" ");
            boolean isGenericGenerator = false;
            if (!"assigned".equals(strategy)) {
                if (!"native".equals(strategy)) {
                    if ("identity".equals(strategy)) {
                        builder.resetAnnotation(this.importType("jakarta.persistence.GeneratedValue"));
                        builder.addAttribute("strategy", this.staticImport("jakarta.persistence.GenerationType", "IDENTITY"));
                        idResult.append(builder.getResult());
                    } else if ("sequence".equals(strategy)) {
                        builder.resetAnnotation(this.importType("jakarta.persistence.GeneratedValue")).addAttribute("strategy", this.staticImport("jakarta.persistence.GenerationType", "SEQUENCE")).addQuotedAttribute("generator", this.clazz.getClassName() + "IdGenerator");
                        idResult.append(builder.getResult());
                        builder.resetAnnotation(this.importType("jakarta.persistence.SequenceGenerator")).addQuotedAttribute("name", this.clazz.getClassName() + "IdGenerator").addQuotedAttribute("sequenceName", properties.getProperty("sequence_name", null));
                        wholeString.append(builder.getResult());
                    } else if (TableGenerator.class.getName().equals(strategy)) {
                        builder.resetAnnotation(this.importType("jakarta.persistence.GeneratedValue")).addAttribute("strategy", this.staticImport("jakarta.persistence.GenerationType", "TABLE")).addQuotedAttribute("generator", this.clazz.getClassName() + "IdGenerator");
                        idResult.append(builder.getResult());
                        this.buildAnnTableGenerator(wholeString, properties);
                    } else {
                        isGenericGenerator = true;
                        builder.resetAnnotation(this.importType("jakarta.persistence.GeneratedValue"));
                        builder.addQuotedAttribute("generator", this.clazz.getClassName() + "IdGenerator");
                        idResult.append(builder.getResult());
                    }
                } else {
                    builder.resetAnnotation(this.importType("jakarta.persistence.GeneratedValue"));
                    idResult.append(builder.getResult());
                }
            }
            if (isGenericGenerator) {
                builder.resetAnnotation(this.importType("org.hibernate.annotations.GenericGenerator")).addQuotedAttribute("name", this.clazz.getClassName() + "IdGenerator").addQuotedAttribute("strategy", strategy);
                ArrayList<AnnotationBuilder> params = new ArrayList<AnnotationBuilder>();
                if (properties != null) {
                    Enumeration<?> propNames = properties.propertyNames();
                    while (propNames.hasMoreElements()) {
                        String propertyName = (String)propNames.nextElement();
                        AnnotationBuilder parameter = AnnotationBuilder.createAnnotation(this.importType("org.hibernate.annotations.Parameter")).addQuotedAttribute("name", propertyName).addQuotedAttribute("value", properties.getProperty(propertyName));
                        params.add(parameter);
                    }
                }
                builder.addAttributes("parameters", params.iterator());
                wholeString.append(builder.getResult());
            }
            wholeString.append(idResult);
        }
        return wholeString.toString();
    }

    private void buildAnnTableGenerator(StringBuffer wholeString, Properties properties) {
        AnnotationBuilder builder = AnnotationBuilder.createAnnotation(this.importType("jakarta.persistence.TableGenerator"));
        builder.addQuotedAttribute("name", this.clazz.getClassName() + "IdGenerator");
        builder.addQuotedAttribute("table", properties.getProperty("generatorTableName", "hibernate_sequences"));
        if (!this.isPropertyDefault("catalog", properties)) {
            builder.addQuotedAttribute("catalog", properties.getProperty("catalog", ""));
        }
        if (!this.isPropertyDefault("schema", properties)) {
            builder.addQuotedAttribute("schema", properties.getProperty("schema", ""));
        }
        if (!this.isPropertyDefault("segment_value", properties)) {
            builder.addQuotedAttribute("pkColumnValue", properties.getProperty("segment_value", ""));
        }
        if (!this.isPropertyDefault("increment_size", properties, "50")) {
            builder.addAttribute("allocationSize", properties.getProperty("increment_size", "50"));
        }
        if (!this.isPropertyDefault("segment_column_name", properties)) {
            builder.addQuotedAttribute("pkColumnName", properties.getProperty("segment_column_name", ""));
        }
        if (!this.isPropertyDefault("value_column_name", properties)) {
            builder.addQuotedAttribute("valueColumnName", properties.getProperty("value_column_name", ""));
        }
        wholeString.append(builder.getResult() + "\n    ");
    }

    private boolean isPropertyDefault(String property, Properties properties) {
        return StringHelper.isEmpty((String)properties.getProperty(property));
    }

    private boolean isPropertyDefault(String property, Properties properties, String defaultValue) {
        String propertyValue = properties.getProperty(property);
        return propertyValue != null && propertyValue.equals(defaultValue);
    }

    public String generateJoinColumnsAnnotation(Property property, Metadata md) {
        String referencedEntityName;
        PersistentClass target;
        Iterator<Selectable> selectablesIterator;
        int span;
        boolean insertable = property.isInsertable();
        boolean updatable = property.isUpdateable();
        Value value = property.getValue();
        Iterator<Selectable> referencedSelectablesIterator = null;
        if (value != null && value instanceof Collection) {
            Collection collection = (Collection)value;
            span = collection.getKey().getColumnSpan();
            selectablesIterator = collection.getKey().getSelectables().iterator();
        } else {
            span = property.getColumnSpan();
            selectablesIterator = property.getSelectables().iterator();
        }
        if (property.getValue() instanceof ToOne && (target = md.getEntityBinding(referencedEntityName = ((ToOne)property.getValue()).getReferencedEntityName())) != null) {
            referencedSelectablesIterator = target.getKey().getSelectables().iterator();
        }
        StringBuffer annotations = new StringBuffer("    ");
        if (span == 1) {
            Selectable selectable = (Selectable)selectablesIterator.next();
            this.buildJoinColumnAnnotation(selectable, null, annotations, insertable, updatable);
        } else {
            Iterator<Selectable> selectables = selectablesIterator;
            annotations.append("@").append(this.importType("jakarta.persistence.JoinColumns")).append("( { ");
            this.buildArrayOfJoinColumnAnnotation(selectables, referencedSelectablesIterator, annotations, insertable, updatable);
            annotations.append(" } )");
        }
        return annotations.toString();
    }

    private void buildArrayOfJoinColumnAnnotation(Iterator<Selectable> columns, Iterator<Selectable> referencedColumnsIterator, StringBuffer annotations, boolean insertable, boolean updatable) {
        while (columns.hasNext()) {
            Selectable selectable = columns.next();
            Selectable referencedColumn = null;
            if (referencedColumnsIterator != null) {
                referencedColumn = referencedColumnsIterator.next();
            }
            if (selectable.isFormula()) continue;
            annotations.append("\n        ");
            this.buildJoinColumnAnnotation(selectable, referencedColumn, annotations, insertable, updatable);
            annotations.append(", ");
        }
        annotations.setLength(annotations.length() - 2);
    }

    private void buildJoinColumnAnnotation(Selectable selectable, Selectable referencedColumn, StringBuffer annotations, boolean insertable, boolean updatable) {
        if (!selectable.isFormula()) {
            Column column = (Column)selectable;
            annotations.append("@").append(this.importType("jakarta.persistence.JoinColumn")).append("(name=\"").append(column.getName()).append("\"");
            if (referencedColumn != null) {
                annotations.append(", referencedColumnName=\"").append(referencedColumn.getText()).append("\"");
            }
            this.appendCommonColumnInfo(annotations, column, insertable, updatable);
            annotations.append(")");
        }
    }

    public String[] getCascadeTypes(Property property) {
        StringTokenizer st = new StringTokenizer(property.getCascade(), ", ", false);
        ArrayList<CallSite> types = new ArrayList<CallSite>();
        while (st.hasMoreElements()) {
            String element = ((String)st.nextElement()).toLowerCase();
            if ("persist".equals(element)) {
                types.add((CallSite)((Object)(this.importType("jakarta.persistence.CascadeType") + ".PERSIST")));
                continue;
            }
            if ("merge".equals(element)) {
                types.add((CallSite)((Object)(this.importType("jakarta.persistence.CascadeType") + ".MERGE")));
                continue;
            }
            if ("delete".equals(element)) {
                types.add((CallSite)((Object)(this.importType("jakarta.persistence.CascadeType") + ".REMOVE")));
                continue;
            }
            if ("refresh".equals(element)) {
                types.add((CallSite)((Object)(this.importType("jakarta.persistence.CascadeType") + ".REFRESH")));
                continue;
            }
            if (!"all".equals(element)) continue;
            types.add((CallSite)((Object)(this.importType("jakarta.persistence.CascadeType") + ".ALL")));
        }
        return types.toArray(new String[types.size()]);
    }

    public String generateManyToOneAnnotation(Property property) {
        StringBuffer buffer = new StringBuffer(AnnotationBuilder.createAnnotation(this.importType("jakarta.persistence.ManyToOne")).addAttribute("cascade", this.getCascadeTypes(property)).addAttribute("fetch", this.getFetchType(property)).getResult());
        buffer.append(this.getHibernateCascadeTypeAnnotation(property));
        return buffer.toString();
    }

    public boolean isSharedPkBasedOneToOne(OneToOne oneToOne) {
        Iterator joinSelectablesIt = oneToOne.getSelectables().iterator();
        HashSet<Selectable> joinSelectables = new HashSet<Selectable>();
        while (joinSelectablesIt.hasNext()) {
            joinSelectables.add((Selectable)joinSelectablesIt.next());
        }
        if (joinSelectables.size() == 0) {
            return false;
        }
        Iterator idSelectablesIt = this.getIdentifierProperty().getSelectables().iterator();
        while (idSelectablesIt.hasNext()) {
            if (joinSelectables.contains(idSelectablesIt.next())) continue;
            return false;
        }
        return true;
    }

    public String generateOneToOneAnnotation(Property property, Metadata md) {
        OneToOne oneToOne = (OneToOne)property.getValue();
        boolean pkIsAlsoFk = this.isSharedPkBasedOneToOne(oneToOne);
        AnnotationBuilder ab = AnnotationBuilder.createAnnotation(this.importType("jakarta.persistence.OneToOne")).addAttribute("cascade", this.getCascadeTypes(property)).addAttribute("fetch", this.getFetchType(property));
        if (oneToOne.getForeignKeyType().equals((Object)ForeignKeyDirection.TO_PARENT)) {
            ab.addQuotedAttribute("mappedBy", this.getOneToOneMappedBy(md, oneToOne));
        }
        StringBuffer buffer = new StringBuffer(ab.getResult());
        buffer.append(this.getHibernateCascadeTypeAnnotation(property));
        if (pkIsAlsoFk && oneToOne.getForeignKeyType().equals((Object)ForeignKeyDirection.FROM_PARENT)) {
            AnnotationBuilder ab1 = AnnotationBuilder.createAnnotation(this.importType("jakarta.persistence.PrimaryKeyJoinColumn"));
            buffer.append(ab1.getResult());
        }
        return buffer.toString();
    }

    public String getHibernateCascadeTypeAnnotation(Property property) {
        StringTokenizer st = new StringTokenizer(property.getCascade(), ", ", false);
        String cascadeType = null;
        StringBuffer cascade = new StringBuffer();
        while (st.hasMoreElements()) {
            String element = ((String)st.nextElement()).toLowerCase();
            if ("all-delete-orphan".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("org.hibernate.annotations.CascadeType");
                }
                cascade.append(cascadeType).append(".ALL").append(", ").append(cascadeType).append(".DELETE_ORPHAN").append(", ");
                continue;
            }
            if ("delete-orphan".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("org.hibernate.annotations.CascadeType");
                }
                cascade.append(cascadeType).append(".DELETE_ORPHAN").append(", ");
                continue;
            }
            if ("save-update".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("org.hibernate.annotations.CascadeType");
                }
                cascade.append(cascadeType).append(".SAVE_UPDATE").append(", ");
                continue;
            }
            if ("replicate".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("org.hibernate.annotations.CascadeType");
                }
                cascade.append(cascadeType).append(".REPLICATE").append(", ");
                continue;
            }
            if ("lock".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("org.hibernate.annotations.CascadeType");
                }
                cascade.append(cascadeType).append(".LOCK").append(", ");
                continue;
            }
            if (!"evict".equals(element)) continue;
            if (cascadeType == null) {
                cascadeType = this.importType("org.hibernate.annotations.CascadeType");
            }
            cascade.append(cascadeType).append(".EVICT").append(", ");
        }
        if (cascade.length() >= 2) {
            String hibernateCascade = this.importType("org.hibernate.annotations.Cascade");
            cascade.insert(0, "@" + hibernateCascade + "( {");
            cascade.setLength(cascade.length() - 2);
            cascade.append("} )");
        }
        return cascade.toString();
    }

    public String getFetchType(Property property) {
        Value value = property.getValue();
        String fetchType = this.importType("jakarta.persistence.FetchType");
        boolean lazy = false;
        lazy = value instanceof ToOne ? ((ToOne)value).isLazy() : (value instanceof Collection ? ((Collection)value).isLazy() : property.isLazy());
        if (lazy) {
            return fetchType + ".LAZY";
        }
        return fetchType + ".EAGER";
    }

    @Override
    public Object getDecoratedObject() {
        return this.clazz;
    }

    public String generateCollectionAnnotation(Property property, Metadata md) {
        StringBuffer annotation = new StringBuffer();
        Value value = property.getValue();
        if (value != null && value instanceof Collection) {
            String mappedBy;
            Collection collection = (Collection)value;
            if (collection.isOneToMany()) {
                mappedBy = null;
                AnnotationBuilder ab = AnnotationBuilder.createAnnotation(this.importType("jakarta.persistence.OneToMany"));
                ab.addAttribute("cascade", this.getCascadeTypes(property));
                ab.addAttribute("fetch", this.getFetchType(property));
                if (collection.isInverse()) {
                    mappedBy = this.getOneToManyMappedBy(md, collection);
                    ab.addQuotedAttribute("mappedBy", mappedBy);
                }
                annotation.append(ab.getResult());
                if (mappedBy == null) {
                    annotation.append("\n").append(this.generateJoinColumnsAnnotation(property, md));
                }
            } else {
                mappedBy = null;
                AnnotationBuilder ab = AnnotationBuilder.createAnnotation(this.importType("jakarta.persistence.ManyToMany"));
                ab.addAttribute("cascade", this.getCascadeTypes(property));
                ab.addAttribute("fetch", this.getFetchType(property));
                if (collection.isInverse()) {
                    mappedBy = this.getManyToManyMappedBy(md, collection);
                    ab.addQuotedAttribute("mappedBy", mappedBy);
                }
                annotation.append(ab.getResult());
                if (mappedBy == null) {
                    String uniqueConstraint;
                    annotation.append("\n    @");
                    annotation.append(this.importType("jakarta.persistence.JoinTable")).append("(name=\"");
                    Table table = collection.getCollectionTable();
                    annotation.append(table.getName());
                    annotation.append("\"");
                    if (StringHelper.isNotEmpty((String)table.getSchema())) {
                        annotation.append(", schema=\"").append(table.getSchema()).append("\"");
                    }
                    if (StringHelper.isNotEmpty((String)table.getCatalog())) {
                        annotation.append(", catalog=\"").append(table.getCatalog()).append("\"");
                    }
                    if ((uniqueConstraint = this.generateAnnTableUniqueConstraint(table)).length() > 0) {
                        annotation.append(", uniqueConstraints=").append(uniqueConstraint);
                    }
                    annotation.append(", joinColumns = { ");
                    this.buildArrayOfJoinColumnAnnotation(collection.getKey().getSelectables().iterator(), null, annotation, property.isInsertable(), property.isUpdateable());
                    annotation.append(" }");
                    annotation.append(", inverseJoinColumns = { ");
                    this.buildArrayOfJoinColumnAnnotation(collection.getElement().getSelectables().iterator(), null, annotation, property.isInsertable(), property.isUpdateable());
                    annotation.append(" }");
                    annotation.append(")");
                }
            }
            String hibernateCascade = this.getHibernateCascadeTypeAnnotation(property);
            if (hibernateCascade.length() > 0) {
                annotation.append("\n    ").append(hibernateCascade);
            }
        }
        return annotation.toString();
    }

    private String getManyToManyMappedBy(Metadata md, Collection collection) {
        Iterator joinColumnsIt = collection.getKey().getSelectables().iterator();
        HashSet<Selectable> joinColumns = new HashSet<Selectable>();
        while (joinColumnsIt.hasNext()) {
            joinColumns.add((Selectable)joinColumnsIt.next());
        }
        ManyToOne manyToOne = (ManyToOne)collection.getElement();
        PersistentClass pc = md.getEntityBinding(manyToOne.getReferencedEntityName());
        Iterator properties = pc.getProperties().iterator();
        boolean isOtherSide = false;
        String mappedBy = "unresolved";
        while (!isOtherSide && properties.hasNext()) {
            Collection realCollectionValue;
            Property collectionProperty = (Property)properties.next();
            Value collectionValue = collectionProperty.getValue();
            if (collectionValue == null || !(collectionValue instanceof Collection) || (realCollectionValue = (Collection)collectionValue).isOneToMany() || joinColumns.size() != realCollectionValue.getElement().getColumnSpan()) continue;
            isOtherSide = true;
            for (Selectable selectable : realCollectionValue.getElement().getSelectables()) {
                if (joinColumns.contains(selectable)) continue;
                isOtherSide = false;
                break;
            }
            if (!isOtherSide) continue;
            mappedBy = collectionProperty.getName();
        }
        return mappedBy;
    }

    private String getOneToManyMappedBy(Metadata md, Collection collection) {
        Iterator joinColumnsIt = collection.getKey().getSelectables().iterator();
        HashSet<Selectable> joinColumns = new HashSet<Selectable>();
        while (joinColumnsIt.hasNext()) {
            joinColumns.add((Selectable)joinColumnsIt.next());
        }
        OneToMany oneToMany = (OneToMany)collection.getElement();
        PersistentClass pc = md.getEntityBinding(oneToMany.getReferencedEntityName());
        Iterator properties = pc.getProperties().iterator();
        boolean isOtherSide = false;
        String mappedBy = "unresolved";
        while (!isOtherSide && properties.hasNext()) {
            Property manyProperty = (Property)properties.next();
            Value manyValue = manyProperty.getValue();
            if (manyValue == null || !(manyValue instanceof ManyToOne) || joinColumns.size() != manyValue.getColumnSpan()) continue;
            isOtherSide = true;
            for (Selectable selectable : manyValue.getSelectables()) {
                if (joinColumns.contains(selectable)) continue;
                isOtherSide = false;
                break;
            }
            if (!isOtherSide) continue;
            mappedBy = manyProperty.getName();
        }
        return mappedBy;
    }

    private String getOneToOneMappedBy(Metadata md, OneToOne oneToOne) {
        Iterator joinSelectablesIt = oneToOne.getSelectables().iterator();
        HashSet<Selectable> joinSelectables = new HashSet<Selectable>();
        while (joinSelectablesIt.hasNext()) {
            joinSelectables.add((Selectable)joinSelectablesIt.next());
        }
        PersistentClass pc = md.getEntityBinding(oneToOne.getReferencedEntityName());
        String referencedPropertyName = oneToOne.getReferencedPropertyName();
        if (referencedPropertyName != null) {
            return referencedPropertyName;
        }
        Iterator properties = pc.getProperties().iterator();
        boolean isOtherSide = false;
        String mappedBy = "unresolved";
        while (!isOtherSide && properties.hasNext()) {
            Property oneProperty = (Property)properties.next();
            Value manyValue = oneProperty.getValue();
            if (manyValue == null || !(manyValue instanceof OneToOne) && !(manyValue instanceof ManyToOne) || joinSelectables.size() != manyValue.getColumnSpan()) continue;
            isOtherSide = true;
            for (Selectable selectable : manyValue.getSelectables()) {
                if (joinSelectables.contains(selectable)) continue;
                isOtherSide = false;
                break;
            }
            if (!isOtherSide) continue;
            mappedBy = oneProperty.getName();
        }
        return mappedBy;
    }

    @Override
    public boolean isSubclass() {
        return this.clazz.getSuperclass() != null;
    }

    @Override
    public List<Property> getPropertyClosureForFullConstructor() {
        return this.getPropertyClosureForFullConstructor(this.clazz);
    }

    protected List<Property> getPropertyClosureForFullConstructor(PersistentClass pc) {
        ArrayList<Property> l = new ArrayList<Property>(this.getPropertyClosureForSuperclassFullConstructor(pc));
        l.addAll(this.getPropertiesForFullConstructor(pc));
        return l;
    }

    @Override
    public List<Property> getPropertiesForFullConstructor() {
        return this.getPropertiesForFullConstructor(this.clazz);
    }

    protected List<Property> getPropertiesForFullConstructor(PersistentClass pc) {
        ArrayList<Property> result = new ArrayList<Property>();
        Iterator<Property> myFields = this.getAllPropertiesIterator(pc);
        while (myFields.hasNext()) {
            Property field = myFields.next();
            if (field.equals(pc.getIdentifierProperty()) && !this.isAssignedIdentifier(pc, field) || field.equals(pc.getVersion()) || field.isBackRef() || this.isFormula(field)) continue;
            result.add(field);
        }
        return result;
    }

    private boolean isFormula(Property field) {
        Value value = field.getValue();
        boolean foundFormula = false;
        if (value != null && value.getColumnSpan() > 0) {
            for (Selectable element : value.getSelectables()) {
                if (!(element instanceof Formula)) {
                    return false;
                }
                foundFormula = true;
            }
        } else {
            return false;
        }
        return foundFormula;
    }

    @Override
    public List<Property> getPropertyClosureForSuperclassFullConstructor() {
        return this.getPropertyClosureForSuperclassFullConstructor(this.clazz);
    }

    public List<Property> getPropertyClosureForSuperclassFullConstructor(PersistentClass pc) {
        ArrayList<Property> result = new ArrayList<Property>();
        if (pc.getSuperclass() != null) {
            result.addAll(this.getPropertyClosureForSuperclassFullConstructor(pc.getSuperclass()));
            result.addAll(this.getPropertiesForFullConstructor(pc.getSuperclass()));
        }
        return result;
    }

    @Override
    public List<Property> getPropertyClosureForMinimalConstructor() {
        return this.getPropertyClosureForMinimalConstructor(this.clazz);
    }

    protected List<Property> getPropertyClosureForMinimalConstructor(PersistentClass pc) {
        ArrayList<Property> l = new ArrayList<Property>(this.getPropertyClosureForSuperclassMinConstructor(pc));
        l.addAll(this.getPropertiesForMinimalConstructor(pc));
        return l;
    }

    @Override
    public List<Property> getPropertiesForMinimalConstructor() {
        return this.getPropertiesForMinimalConstructor(this.clazz);
    }

    protected List<Property> getPropertiesForMinimalConstructor(PersistentClass pc) {
        ArrayList<Property> result = new ArrayList<Property>();
        Iterator<Property> myFields = this.getAllPropertiesIterator(pc);
        while (myFields.hasNext()) {
            Property property = myFields.next();
            if (property.equals(pc.getIdentifierProperty())) {
                if (!this.isAssignedIdentifier(pc, property)) continue;
                result.add(property);
                continue;
            }
            if (property.equals(pc.getVersion()) || !this.isRequiredInConstructor(property)) continue;
            result.add(property);
        }
        return result;
    }

    protected boolean isAssignedIdentifier(PersistentClass pc, Property property) {
        SimpleValue sv;
        return property.equals(pc.getIdentifierProperty()) && property.getValue().isSimpleValue() && "assigned".equals((sv = (SimpleValue)property.getValue()).getIdentifierGeneratorStrategy());
    }

    @Override
    public List<Property> getPropertyClosureForSuperclassMinimalConstructor() {
        return this.getPropertyClosureForSuperclassMinConstructor(this.clazz);
    }

    protected List<Property> getPropertyClosureForSuperclassMinConstructor(PersistentClass pc) {
        ArrayList<Property> result = new ArrayList<Property>();
        if (pc.getSuperclass() != null) {
            result.addAll(this.getPropertyClosureForSuperclassMinConstructor(pc.getSuperclass()));
            result.addAll(this.getPropertiesForMinimalConstructor(pc.getSuperclass()));
        }
        return result;
    }

    @Override
    public POJOClass getSuperClass() {
        if (!this.isSubclass()) {
            return null;
        }
        return new EntityPOJOClass(this.clazz.getSuperclass(), this.c2j);
    }

    public String toString() {
        return "Entity: " + (this.clazz == null ? "<none>" : this.clazz.getEntityName());
    }

    @Override
    public boolean hasVersionProperty() {
        return this.clazz.isVersioned() && this.clazz instanceof RootClass;
    }

    @Override
    public Property getVersionProperty() {
        return this.clazz.getVersion();
    }
}

