/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.reader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.api.reveng.TableIdentifier;

public class ForeignKeysInfo {
    final Map<String, Table> dependentTables;
    final Map<String, List<Column>> dependentColumns;
    final Map<String, List<Column>> referencedColumns;
    private final Table referencedTable;

    public ForeignKeysInfo(Table referencedTable, Map<String, Table> tables, Map<String, List<Column>> columns, Map<String, List<Column>> refColumns) {
        this.referencedTable = referencedTable;
        this.dependentTables = tables;
        this.dependentColumns = columns;
        this.referencedColumns = refColumns;
    }

    public Map<String, List<ForeignKey>> process(RevengStrategy revengStrategy) {
        HashMap<String, List<ForeignKey>> oneToManyCandidates = new HashMap<String, List<ForeignKey>>();
        for (Map.Entry<String, Table> entry : this.dependentTables.entrySet()) {
            String fkName = entry.getKey();
            Table fkTable = entry.getValue();
            List<Column> columns = this.dependentColumns.get(fkName);
            List<Column> refColumns = this.referencedColumns.get(fkName);
            String className = revengStrategy.tableToClassName(TableIdentifier.create(this.referencedTable));
            ForeignKey key = fkTable.createForeignKey(fkName, columns, className, null, refColumns);
            key.setReferencedTable(this.referencedTable);
            this.addToMultiMap(oneToManyCandidates, className, key);
        }
        return oneToManyCandidates;
    }

    private void addToMultiMap(Map<String, List<ForeignKey>> multimap, String key, ForeignKey item) {
        List<ForeignKey> existing = multimap.get(key);
        if (existing == null) {
            existing = new ArrayList<ForeignKey>();
            multimap.put(key, existing);
        }
        existing.add(item);
    }
}

