/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.hibernate.tool.api.metadata.MetadataDescriptor;
import org.hibernate.tool.api.metadata.MetadataDescriptorFactory;
import org.hibernate.tool.api.reveng.RevengSettings;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.api.reveng.RevengStrategyFactory;

public abstract class AbstractGenerationMojo
extends AbstractMojo {
    @Parameter
    private String packageName;
    @Parameter
    private File revengFile;
    @Parameter
    private String revengStrategy;
    @Parameter(defaultValue="true")
    private boolean detectManyToMany;
    @Parameter(defaultValue="true")
    private boolean detectOneToOne;
    @Parameter(defaultValue="true")
    private boolean detectOptimisticLock;
    @Parameter(defaultValue="true")
    private boolean createCollectionForForeignKey;
    @Parameter(defaultValue="true")
    private boolean createManyToOneForForeignKey;
    @Parameter(defaultValue="${project.basedir}/src/main/resources/hibernate.properties")
    private File propertyFile;
    private boolean preferBasicCompositeIds = true;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.createExporterClassLoader(original));
            this.getLog().info((CharSequence)("Starting " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
            RevengStrategy strategy = this.setupReverseEngineeringStrategy();
            if (this.propertyFile.exists()) {
                this.executeExporter(this.createJdbcDescriptor(strategy, this.loadPropertiesFile()));
            } else {
                this.getLog().info((CharSequence)("Property file '" + this.propertyFile + "' cannot be found, aborting..."));
            }
            this.getLog().info((CharSequence)("Finished " + ((Object)((Object)this)).getClass().getSimpleName() + "!"));
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private RevengStrategy setupReverseEngineeringStrategy() {
        File[] revengFiles = null;
        if (this.revengFile != null) {
            revengFiles = new File[]{this.revengFile};
        }
        RevengStrategy strategy = RevengStrategyFactory.createReverseEngineeringStrategy((String)this.revengStrategy, revengFiles);
        RevengSettings settings = new RevengSettings(strategy).setDefaultPackageName(this.packageName).setDetectManyToMany(this.detectManyToMany).setDetectOneToOne(this.detectOneToOne).setDetectOptimisticLock(this.detectOptimisticLock).setCreateCollectionForForeignKey(this.createCollectionForForeignKey).setCreateManyToOneForForeignKey(this.createManyToOneForForeignKey);
        strategy.setSettings(settings);
        return strategy;
    }

    private Properties loadPropertiesFile() {
        Properties properties;
        FileInputStream is = new FileInputStream(this.propertyFile);
        try {
            Properties result = new Properties();
            result.load(is);
            properties = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new BuildException(this.propertyFile + " not found.", (Throwable)e);
            }
            catch (IOException e) {
                throw new BuildException("Problem while loading " + this.propertyFile, (Throwable)e);
            }
        }
        is.close();
        return properties;
    }

    private MetadataDescriptor createJdbcDescriptor(RevengStrategy strategy, Properties properties) {
        properties.put("org.hibernate.tool.api.metadata.MetadataConstants.PreferBasicCompositeIds", (Object)this.preferBasicCompositeIds);
        return MetadataDescriptorFactory.createReverseEngineeringDescriptor((RevengStrategy)strategy, (Properties)properties);
    }

    private ClassLoader createExporterClassLoader(ClassLoader parent) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (String cpe : this.project.getRuntimeClasspathElements()) {
                urls.add(new File(cpe).toURI().toURL());
            }
        }
        catch (MalformedURLException | DependencyResolutionRequiredException e) {
            throw new RuntimeException("Problem while constructing project classloader", e);
        }
        return new URLClassLoader(urls.toArray(new URL[0]), parent);
    }

    protected abstract void executeExporter(MetadataDescriptor var1);
}

