/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.sql.Connection;
import java.util.TimeZone;
import org.hibernate.FlushMode;
import org.hibernate.Interceptor;
import org.hibernate.SessionEventListener;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.FullTextSharedSessionBuilder;
import org.hibernate.search.Search;

class FullTextSharedSessionBuilderDelegator
implements FullTextSharedSessionBuilder {
    private final SharedSessionBuilder builder;

    public FullTextSharedSessionBuilderDelegator(SharedSessionBuilder builder) {
        this.builder = builder;
    }

    @Override
    public FullTextSharedSessionBuilder interceptor() {
        this.builder.interceptor();
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder connection() {
        this.builder.connection();
        return this;
    }

    @Override
    @Deprecated
    public FullTextSharedSessionBuilder connectionReleaseMode() {
        this.builder.connectionReleaseMode();
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder autoJoinTransactions() {
        this.builder.autoJoinTransactions();
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder autoClose() {
        this.builder.autoClose();
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder interceptor(Interceptor interceptor) {
        this.builder.interceptor(interceptor);
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder noInterceptor() {
        this.builder.noInterceptor();
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder connection(Connection connection) {
        this.builder.connection(connection);
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder autoJoinTransactions(boolean autoJoinTransactions) {
        this.builder.autoJoinTransactions(autoJoinTransactions);
        return this;
    }

    @Override
    @Deprecated
    public FullTextSharedSessionBuilder autoClose(boolean autoClose) {
        this.builder.autoClose(autoClose);
        return this;
    }

    @Override
    public FullTextSession openSession() {
        return Search.getFullTextSession(this.builder.openSession());
    }

    @Override
    @Deprecated(forRemoval=true)
    public FullTextSharedSessionBuilder tenantIdentifier(String tenantIdentifier) {
        this.builder.tenantIdentifier(tenantIdentifier);
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder tenantIdentifier(Object tenantIdentifier) {
        this.builder.tenantIdentifier(tenantIdentifier);
        return this;
    }

    public FullTextSharedSessionBuilder clearEventListeners() {
        this.builder.clearEventListeners();
        return this;
    }

    public FullTextSharedSessionBuilder eventListeners(SessionEventListener ... listeners) {
        this.builder.eventListeners(listeners);
        return this;
    }

    public FullTextSharedSessionBuilder statementInspector(StatementInspector statementInspector) {
        this.builder.statementInspector(statementInspector);
        return this;
    }

    public FullTextSharedSessionBuilder connectionHandlingMode() {
        this.builder.connectionHandlingMode();
        return this;
    }

    public FullTextSharedSessionBuilder flushMode() {
        this.builder.flushMode();
        return this;
    }

    public FullTextSharedSessionBuilder connectionHandlingMode(PhysicalConnectionHandlingMode mode) {
        this.builder.connectionHandlingMode(mode);
        return this;
    }

    public FullTextSharedSessionBuilder autoClear(boolean autoClear) {
        this.builder.autoClear(autoClear);
        return this;
    }

    public FullTextSharedSessionBuilder flushMode(FlushMode flushMode) {
        this.builder.flushMode(flushMode);
        return this;
    }

    public FullTextSharedSessionBuilder jdbcTimeZone(TimeZone timeZone) {
        this.builder.jdbcTimeZone(timeZone);
        return this;
    }
}

