/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.List;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.dsl.AggregationFinalStep;
import org.hibernate.search.engine.search.aggregation.dsl.TypedSearchAggregationFactory;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;

public abstract class FacetingRequestImpl<A>
implements FacetingRequest {
    private final AggregationKey<A> key;
    private final String fieldName;
    protected FacetSortOrder sort = FacetSortOrder.COUNT_DESC;
    protected boolean includeZeroCounts = false;
    protected int maxNumberOfFacets = 1;

    public FacetingRequestImpl(String name, String fieldName) {
        if (name == null) {
            throw new IllegalArgumentException("The request name name cannot be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("The field name cannot be null");
        }
        this.key = AggregationKey.of((String)name);
        this.fieldName = fieldName;
    }

    @Override
    public String getFacetingName() {
        return this.key.name();
    }

    public AggregationKey<A> getKey() {
        return this.key;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public void setSort(FacetSortOrder sort) {
        this.sort = sort;
    }

    @Override
    public FacetSortOrder getSort() {
        return this.sort;
    }

    @Override
    public int getMaxNumberOfFacets() {
        return this.maxNumberOfFacets;
    }

    public void setMaxNumberOfFacets(int maxNumberOfFacets) {
        this.maxNumberOfFacets = maxNumberOfFacets;
    }

    public abstract AggregationFinalStep<A> requestAggregation(TypedSearchAggregationFactory<?> var1);

    public abstract List<Facet> toFacets(A var1);

    @Override
    public boolean hasZeroCountsIncluded() {
        return this.includeZeroCounts;
    }

    public void setIncludeZeroCounts(boolean includeZeroCounts) {
        this.includeZeroCounts = includeZeroCounts;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FacetingRequest");
        sb.append("{name='").append(this.key.name()).append('\'');
        sb.append(", fieldName='").append(this.fieldName).append('\'');
        sb.append(", sort=").append((Object)this.sort);
        sb.append(", includeZeroCounts=").append(this.includeZeroCounts);
        sb.append(", maxNumberOfFacets=").append(this.maxNumberOfFacets);
        sb.append('}');
        return sb.toString();
    }
}

