/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;

public class FacetRange<T> {
    private static final String MIN_INCLUDED = "[";
    private static final String MIN_EXCLUDED = "(";
    private static final String MAX_INCLUDED = "]";
    private static final String MAX_EXCLUDED = ")";
    private final Range<T> range;
    private final String rangeString;
    private final String fieldName;
    private final Class<?> rangeType;

    public FacetRange(Class<?> rangeType, Range<T> range, String fieldName) {
        this.range = range;
        this.fieldName = fieldName;
        this.rangeString = this.buildRangeString();
        this.rangeType = rangeType;
    }

    public Range<T> range() {
        return this.range;
    }

    public T getMin() {
        return this.range.lowerBoundValue().orElse(null);
    }

    public T getMax() {
        return this.range.upperBoundValue().orElse(null);
    }

    public boolean isMinIncluded() {
        return RangeBoundInclusion.INCLUDED.equals((Object)this.range.lowerBoundInclusion());
    }

    public boolean isMaxIncluded() {
        return RangeBoundInclusion.INCLUDED.equals((Object)this.range.upperBoundInclusion());
    }

    public String getRangeString() {
        return this.rangeString;
    }

    private String buildRangeString() {
        StringBuilder builder = new StringBuilder();
        if (this.isMinIncluded()) {
            builder.append(MIN_INCLUDED);
        } else {
            builder.append(MIN_EXCLUDED);
        }
        if (this.getMin() != null) {
            builder.append(this.getMin());
        }
        builder.append(", ");
        if (this.getMax() != null) {
            builder.append(this.getMax());
        }
        if (this.isMaxIncluded()) {
            builder.append(MAX_INCLUDED);
        } else {
            builder.append(MAX_EXCLUDED);
        }
        return builder.toString();
    }

    public String toString() {
        return "FacetRange{min=" + String.valueOf(this.getMin()) + ", max=" + String.valueOf(this.getMax()) + ", includeMin=" + this.isMinIncluded() + ", includeMax=" + this.isMaxIncluded() + ", fieldName='" + this.fieldName + "', rangeType=" + String.valueOf(this.rangeType) + "}";
    }
}

