/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.search.aggregation.dsl.AggregationFinalStep;
import org.hibernate.search.engine.search.aggregation.dsl.TermsAggregationOptionsStep;
import org.hibernate.search.engine.search.aggregation.dsl.TypedSearchAggregationFactory;
import org.hibernate.search.query.dsl.impl.AbstractFacet;
import org.hibernate.search.query.dsl.impl.FacetingRequestImpl;
import org.hibernate.search.query.facet.Facet;

public class DiscreteFacetRequest
extends FacetingRequestImpl<Map<Object, Long>> {
    DiscreteFacetRequest(String name, String fieldName) {
        super(name, fieldName);
    }

    @Override
    public AggregationFinalStep<Map<Object, Long>> requestAggregation(TypedSearchAggregationFactory<?> factory) {
        TermsAggregationOptionsStep optionsStep = factory.terms().field(this.getFieldName(), Object.class);
        if (this.maxNumberOfFacets >= 0) {
            optionsStep = optionsStep.maxTermCount(this.maxNumberOfFacets);
        }
        if (this.includeZeroCounts) {
            optionsStep.minDocumentCount(0);
        }
        switch (this.sort) {
            case COUNT_ASC: {
                optionsStep = optionsStep.orderByCountAscending();
                break;
            }
            case COUNT_DESC: {
                optionsStep = optionsStep.orderByCountDescending();
                break;
            }
            case FIELD_VALUE: {
                optionsStep = optionsStep.orderByTermAscending();
                break;
            }
        }
        return optionsStep;
    }

    @Override
    public List<Facet> toFacets(Map<Object, Long> aggregation) {
        ArrayList<Facet> result = new ArrayList<Facet>(aggregation.size());
        for (Map.Entry<Object, Long> entry : aggregation.entrySet()) {
            String value = String.valueOf(entry.getKey());
            int count = Math.toIntExact(entry.getValue());
            result.add(new SimpleFacet(this.getFacetingName(), this.getFieldName(), value, count));
        }
        return result;
    }

    static class SimpleFacet
    extends AbstractFacet {
        SimpleFacet(String facetingName, String absoluteFieldPath, String value, int count) {
            super(facetingName, absoluteFieldPath, value, count);
        }
    }
}

