/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.LuceneExtension;
import org.hibernate.search.backend.lucene.search.predicate.dsl.LuceneSearchPredicateFactory;
import org.hibernate.search.backend.lucene.search.spi.LuceneMigrationUtils;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.MatchAllPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateScoreStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactoryExtension;
import org.hibernate.search.query.dsl.AllContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;

public class ConnectedAllContext
implements AllContext {
    private final QueryBuildingContext queryContext;
    private final List<Query> except;
    private final QueryCustomizer queryCustomizer;

    public ConnectedAllContext(QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = new QueryCustomizer();
        this.except = new ArrayList<Query>();
    }

    @Override
    public Query createQuery() {
        return LuceneMigrationUtils.toLuceneQuery((SearchPredicate)this.createPredicate());
    }

    private SearchPredicate createPredicate() {
        SearchPredicateFactory<?> factory = this.queryContext.getScope().predicate();
        MatchAllPredicateOptionsStep optionsStep = factory.matchAll();
        for (Query query : this.except) {
            optionsStep = optionsStep.except(((LuceneSearchPredicateFactory)factory.extension((SearchPredicateFactoryExtension)LuceneExtension.get())).fromLuceneQuery(query));
        }
        this.queryCustomizer.applyScoreOptions((PredicateScoreStep<?>)optionsStep);
        SearchPredicate predicate = optionsStep.toPredicate();
        return this.queryCustomizer.applyFilter(factory, predicate);
    }

    @Override
    public AllContext except(Query ... queriesMatchingExcludedDocuments) {
        Collections.addAll(this.except, queriesMatchingExcludedDocuments);
        return this;
    }

    @Override
    public AllContext boostedTo(float boost) {
        this.queryCustomizer.boostedTo(boost);
        return this;
    }

    @Override
    public AllContext withConstantScore() {
        this.queryCustomizer.withConstantScore();
        return this;
    }

    @Override
    public AllContext filteredBy(Query filter) {
        this.queryCustomizer.filteredBy(filter);
        return this;
    }
}

