/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.spi.LuceneMigrationUtils;
import org.hibernate.search.engine.search.common.BooleanOperator;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateScoreStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryStringPredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryStringPredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryStringPredicateOptionsStep;
import org.hibernate.search.query.dsl.SimpleQueryStringTermination;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.FieldsContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.hibernate.search.util.logging.impl.MigrationHelperLog;

public class ConnectedMultiFieldsSimpleQueryStringQueryBuilder
implements SimpleQueryStringTermination {
    private static final MigrationHelperLog log = LoggerFactory.make(MethodHandles.lookup());
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final FieldsContext fieldsContext;
    private final String simpleQueryString;
    private final boolean withAndAsDefaultOperator;

    public ConnectedMultiFieldsSimpleQueryStringQueryBuilder(QueryBuildingContext queryContext, QueryCustomizer queryCustomizer, FieldsContext fieldsContext, String simpleQueryString, boolean withAndAsDefaultOperator) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.fieldsContext = fieldsContext;
        this.simpleQueryString = simpleQueryString;
        this.withAndAsDefaultOperator = withAndAsDefaultOperator;
    }

    @Override
    public Query createQuery() {
        return LuceneMigrationUtils.toLuceneQuery((SearchPredicate)this.createPredicate());
    }

    private SearchPredicate createPredicate() {
        SearchPredicateFactory factory = this.queryContext.getScope().predicate();
        SimpleQueryStringPredicateFieldStep fieldStep = factory.simpleQueryString();
        SimpleQueryStringPredicateFieldMoreStep fieldMoreStep = null;
        for (FieldContext fieldContext : this.fieldsContext) {
            fieldMoreStep = (SimpleQueryStringPredicateFieldMoreStep)fieldContext.applyBoost(fieldStep.field(fieldContext.getField()));
        }
        SimpleQueryStringPredicateOptionsStep optionsStep = (SimpleQueryStringPredicateOptionsStep)((SimpleQueryStringPredicateOptionsStep)fieldMoreStep.matching(this.simpleQueryString)).defaultOperator(this.withAndAsDefaultOperator ? BooleanOperator.AND : BooleanOperator.OR);
        String overriddenAnalyzer = this.overriddenAnalyzer();
        if (overriddenAnalyzer != null) {
            optionsStep = (SimpleQueryStringPredicateOptionsStep)optionsStep.analyzer(overriddenAnalyzer);
        }
        this.queryCustomizer.applyScoreOptions((PredicateScoreStep<?>)optionsStep);
        SearchPredicate predicate = optionsStep.toPredicate();
        return this.queryCustomizer.applyFilter(factory, predicate);
    }

    private String overriddenAnalyzer() {
        HashSet<String> effectiveAnalyzers = new HashSet<String>();
        String overriddenAnalyzer = null;
        for (FieldContext fieldContext : this.fieldsContext) {
            String fieldEffectiveAnalyzer;
            String fieldName = fieldContext.getField();
            String fieldOverriddenAnalyzer = this.queryContext.getOverriddenAnalyzer(fieldName);
            if (fieldOverriddenAnalyzer == null) {
                fieldEffectiveAnalyzer = this.queryContext.getOriginalAnalyzer(fieldName);
            } else {
                fieldEffectiveAnalyzer = fieldOverriddenAnalyzer;
                if (overriddenAnalyzer == null) {
                    overriddenAnalyzer = fieldOverriddenAnalyzer;
                }
            }
            if (fieldEffectiveAnalyzer == null) continue;
            effectiveAnalyzers.add(fieldEffectiveAnalyzer);
        }
        if (overriddenAnalyzer != null && effectiveAnalyzers.size() > 1) {
            throw log.unableToOverrideQueryAnalyzerWithMoreThanOneAnalyzerForSimpleQueryStringQueries(effectiveAnalyzers);
        }
        return overriddenAnalyzer;
    }
}

