/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.engine.search.predicate.dsl.RangePredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.query.dsl.RangeTerminationExcludable;
import org.hibernate.search.query.dsl.impl.AbstractConnectedMultiFieldsQueryBuilder;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.FieldsContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.RangeQueryContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;

public class ConnectedMultiFieldsRangeQueryBuilder
extends AbstractConnectedMultiFieldsQueryBuilder<RangeTerminationExcludable, RangePredicateOptionsStep<?>>
implements RangeTerminationExcludable {
    private final RangeQueryContext rangeContext;

    public ConnectedMultiFieldsRangeQueryBuilder(QueryBuildingContext queryContext, QueryCustomizer queryCustomizer, FieldsContext fieldsContext, RangeQueryContext rangeContext) {
        super(queryContext, queryCustomizer, fieldsContext);
        this.rangeContext = rangeContext;
    }

    @Override
    public RangeTerminationExcludable excludeLimit() {
        if (this.rangeContext.getFrom() != null && this.rangeContext.getTo() != null) {
            this.rangeContext.setExcludeTo(true);
        } else if (this.rangeContext.getFrom() != null) {
            this.rangeContext.setExcludeFrom(true);
        } else if (this.rangeContext.getTo() != null) {
            this.rangeContext.setExcludeTo(true);
        } else {
            throw new AssertionFailure("Both from and to clause of a range query are null");
        }
        return this;
    }

    @Override
    protected RangePredicateOptionsStep<?> createPredicate(SearchPredicateFactory factory, FieldContext fieldContext) {
        return ((RangePredicateFieldMoreStep)fieldContext.applyBoost(factory.range().field(fieldContext.getField()))).within(Range.between((Object)this.rangeContext.getFrom(), (RangeBoundInclusion)(this.rangeContext.isExcludeFrom() ? RangeBoundInclusion.EXCLUDED : RangeBoundInclusion.INCLUDED), (Object)this.rangeContext.getTo(), (RangeBoundInclusion)(this.rangeContext.isExcludeTo() ? RangeBoundInclusion.EXCLUDED : RangeBoundInclusion.INCLUDED)), fieldContext.getValueConvert());
    }
}

