/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.engine.search.predicate.dsl.MatchPredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.MatchPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.query.dsl.TermTermination;
import org.hibernate.search.query.dsl.impl.AbstractConnectedMultiFieldsQueryBuilder;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.FieldsContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.TermQueryContext;

public class ConnectedMultiFieldsMatchQueryBuilder
extends AbstractConnectedMultiFieldsQueryBuilder<TermTermination, MatchPredicateOptionsStep<?>>
implements TermTermination {
    private final Object value;
    private final TermQueryContext termContext;

    public ConnectedMultiFieldsMatchQueryBuilder(QueryBuildingContext queryContext, QueryCustomizer queryCustomizer, FieldsContext fieldsContext, Object value, TermQueryContext termContext) {
        super(queryContext, queryCustomizer, fieldsContext);
        this.value = value;
        this.termContext = termContext;
    }

    @Override
    protected MatchPredicateOptionsStep<?> createPredicate(SearchPredicateFactory factory, FieldContext fieldContext) {
        MatchPredicateOptionsStep optionsStep = ((MatchPredicateFieldMoreStep)fieldContext.applyBoost(factory.match().field(fieldContext.getField()))).matching(this.value, fieldContext.getValueConvert());
        if (TermQueryContext.Approximation.FUZZY.equals((Object)this.termContext.getApproximation())) {
            optionsStep.fuzzy(this.termContext.getMaxEditDistance(), this.termContext.getPrefixLength());
        }
        if (fieldContext.skipAnalysis()) {
            optionsStep = optionsStep.skipAnalysis();
        } else {
            String overriddenAnalyzer = this.queryContext.getOverriddenAnalyzer(fieldContext.getField());
            if (overriddenAnalyzer != null) {
                optionsStep = optionsStep.analyzer(overriddenAnalyzer);
            }
        }
        return optionsStep;
    }
}

