/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.search.query.SearchResult;
import org.hibernate.search.engine.search.query.dsl.SearchQueryOptionsStep;
import org.hibernate.search.query.dsl.impl.FacetingRequestImpl;
import org.hibernate.search.query.engine.impl.HSQueryImpl;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetingRequest;

public class FacetManagerImpl
implements FacetManager {
    private Map<String, FacetingRequestImpl<?>> facetRequests;
    private Map<String, List<Facet>> facetResults;
    private final HSQueryImpl<?> query;

    public FacetManagerImpl(HSQueryImpl<?> query) {
        this.query = query;
    }

    @Override
    public FacetManager enableFaceting(FacetingRequest facetingRequest) {
        if (this.facetRequests == null) {
            this.facetRequests = new HashMap();
        }
        this.facetRequests.put(facetingRequest.getFacetingName(), (FacetingRequestImpl)facetingRequest);
        this.facetsHaveChanged();
        return this;
    }

    @Override
    public void disableFaceting(String facetingName) {
        if (this.facetRequests != null) {
            this.facetRequests.remove(facetingName);
        }
        if (this.facetResults != null) {
            this.facetResults.remove(facetingName);
        }
        this.facetsHaveChanged();
    }

    @Override
    public List<Facet> getFacets(String facetingName) {
        List<Facet> facets;
        if (!this.hasFacets()) {
            return Collections.emptyList();
        }
        if (this.facetResults == null) {
            this.query.doFetch(0, 0);
        }
        if ((facets = this.facetResults.get(facetingName)) == null) {
            return Collections.emptyList();
        }
        return facets;
    }

    <LOS> SearchQueryOptionsStep<?, ?, LOS, ?, ?> contributeAggregations(SearchQueryOptionsStep<?, ?, LOS, ?, ?> optionsStep) {
        if (!this.hasFacets()) {
            return optionsStep;
        }
        for (FacetingRequestImpl<?> facetRequest : this.facetRequests.values()) {
            optionsStep = this.requestAggregation(optionsStep, facetRequest);
        }
        return optionsStep;
    }

    void setFacetResults(SearchResult<?> result) {
        if (!this.hasFacets()) {
            return;
        }
        this.facetResults = new HashMap<String, List<Facet>>();
        for (Map.Entry<String, FacetingRequestImpl<?>> entry : this.facetRequests.entrySet()) {
            List<Facet> facets = this.extractFacets(result, entry.getValue());
            this.facetResults.put(entry.getKey(), facets);
        }
    }

    private boolean hasFacets() {
        return this.facetRequests != null && !this.facetRequests.isEmpty();
    }

    private <LOS, A> SearchQueryOptionsStep<?, ?, LOS, ?, ?> requestAggregation(SearchQueryOptionsStep<?, ?, LOS, ?, ?> optionsStep, FacetingRequestImpl<A> facetRequest) {
        return optionsStep.aggregation(facetRequest.getKey(), facetRequest::requestAggregation);
    }

    private <A> List<Facet> extractFacets(SearchResult<?> result, FacetingRequestImpl<A> facetRequest) {
        Object aggregation = result.aggregation(facetRequest.getKey());
        return facetRequest.toFacets(aggregation);
    }

    private void facetsHaveChanged() {
        this.facetResults = null;
    }
}

