/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.search.backend.lucene.LuceneExtension;
import org.hibernate.search.backend.lucene.search.predicate.dsl.LuceneSearchPredicateFactory;
import org.hibernate.search.backend.lucene.search.projection.dsl.LuceneSearchProjectionFactory;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchQuery;
import org.hibernate.search.backend.lucene.search.sort.dsl.LuceneSearchSortFactory;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactoryExtension;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.ProjectionFinalStep;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactoryExtension;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.engine.search.query.SearchQueryExtension;
import org.hibernate.search.engine.search.query.SearchResult;
import org.hibernate.search.engine.search.query.SearchScroll;
import org.hibernate.search.engine.search.query.dsl.SearchQueryOptionsStep;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactoryExtension;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.query.engine.impl.FacetManagerImpl;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.TupleTransformer;
import org.hibernate.search.query.engine.spi.V5MigrationSearchSession;
import org.hibernate.search.scope.spi.V5MigrationSearchScope;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class HSQueryImpl<LOS>
implements HSQuery {
    private static final String HSEARCH_PROJECTION_FIELD_PREFIX = "__HSearch_";
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final V5MigrationSearchScope scope;
    private final V5MigrationSearchSession<LOS> session;
    private final Query query;
    private final Consumer<LOS> loadOptionsContributor;
    private final SearchPredicate predicate;
    private final FacetManagerImpl facetManager;
    private String[] projectedFields;
    private SearchSort sort;
    private Coordinates spatialSearchCenter = null;
    private String spatialFieldName = null;
    private int offset = 0;
    private Integer limit = null;
    private long timeoutValue;
    private TimeUnit timeoutUnit;
    private TimeoutType timeoutType;
    private boolean partialResult;
    private Integer resultSize;
    private TupleTransformer tupleTransformer;

    public HSQueryImpl(V5MigrationSearchScope scope, V5MigrationSearchSession<LOS> session, Query query, Consumer<LOS> loadOptionsContributor) {
        this.scope = scope;
        this.session = session;
        this.query = query;
        this.loadOptionsContributor = loadOptionsContributor;
        this.predicate = ((LuceneSearchPredicateFactory)scope.predicate().extension((SearchPredicateFactoryExtension)LuceneExtension.get())).fromLuceneQuery(query).toPredicate();
        this.facetManager = new FacetManagerImpl(this);
    }

    @Override
    public HSQuery sort(Sort sort) {
        this.sort = sort == null ? null : ((LuceneSearchSortFactory)this.scope.sort().extension((SearchSortFactoryExtension)LuceneExtension.get())).fromLuceneSort(sort).toSort();
        return this;
    }

    @Override
    public HSQuery projection(String ... fields) {
        this.projectedFields = fields;
        return this;
    }

    @Override
    public HSQuery firstResult(int firstResult) {
        this.offset = firstResult;
        return this;
    }

    @Override
    public HSQuery maxResults(int maxResults) {
        this.limit = maxResults;
        return this;
    }

    @Override
    public Set<Class<?>> getTargetedEntities() {
        return this.scope.targetTypes();
    }

    @Override
    public String[] getProjectedFields() {
        return this.projectedFields;
    }

    @Override
    public void failAfter(long timeout, TimeUnit timeUnit) {
        this.timeoutValue = timeout;
        this.timeoutUnit = timeUnit;
        this.timeoutType = TimeoutType.FAIL;
    }

    @Override
    public void truncateAfter(long timeout, TimeUnit timeUnit) {
        this.timeoutValue = timeout;
        this.timeoutUnit = timeUnit;
        this.timeoutType = TimeoutType.TRUNCATE;
    }

    @Override
    public FacetManager getFacetManager() {
        return this.facetManager;
    }

    @Override
    public Query getLuceneQuery() {
        return this.query;
    }

    @Override
    public String getQueryString() {
        return String.valueOf(this.query);
    }

    @Override
    public List<?> fetch() {
        return this.doFetch(this.offset, this.limit);
    }

    @Override
    public boolean hasPartialResults() {
        return this.partialResult;
    }

    @Override
    public int getResultSize() {
        if (this.resultSize != null) {
            return this.resultSize;
        }
        this.resultSize = Math.toIntExact(this.createSearchQuery().fetchTotalHitCount());
        return this.resultSize;
    }

    @Override
    public SearchScroll<?> scroll(int chunkSize) {
        if (this.offset > 0) {
            throw log.cannotUseSetFirstResultWithScroll();
        }
        return this.createSearchQuery().scroll(chunkSize);
    }

    @Override
    public Explanation explain(Object entityId) {
        return ((LuceneSearchQuery)this.createSearchQuery().extension((SearchQueryExtension)LuceneExtension.get())).explain(entityId);
    }

    @Override
    public HSQuery setSpatialParameters(Coordinates center, String fieldName) {
        this.spatialSearchCenter = center;
        this.spatialFieldName = fieldName;
        return this;
    }

    @Override
    public HSQuery tupleTransformer(TupleTransformer tupleTransformer) {
        this.tupleTransformer = tupleTransformer;
        return this;
    }

    List<?> doFetch(int offset, Integer limit) {
        SearchResult result = this.createSearchQuery().fetch(Integer.valueOf(offset), limit);
        this.resultSize = Math.toIntExact(result.total().hitCountLowerBound());
        this.partialResult = result.timedOut();
        this.facetManager.setFacetResults(result);
        return result.hits();
    }

    private SearchQuery<?> createSearchQuery() {
        SearchProjection<?> projection = this.createCompositeProjection();
        if (this.sort == null) {
            this.sort = this.scope.sort().score().toSort();
        }
        SearchQueryOptionsStep optionsStep = this.session.search(this.scope).select(projection).where(this.predicate).sort(this.sort);
        if (this.loadOptionsContributor != null) {
            optionsStep = optionsStep.loading(this.loadOptionsContributor);
        }
        if (this.timeoutType != null) {
            switch (this.timeoutType) {
                case FAIL: {
                    optionsStep.failAfter(this.timeoutValue, this.timeoutUnit);
                    break;
                }
                case TRUNCATE: {
                    optionsStep.truncateAfter(this.timeoutValue, this.timeoutUnit);
                }
            }
        }
        optionsStep = this.facetManager.contributeAggregations(optionsStep);
        return optionsStep.toQuery();
    }

    private SearchProjection<?> createCompositeProjection() {
        SearchProjectionFactory<?, ?> factory = this.scope.projection();
        if (this.projectedFields == null || this.projectedFields.length == 0) {
            return factory.entity().toProjection();
        }
        SearchProjection[] projections = new SearchProjection[this.projectedFields.length];
        for (int i = 0; i < this.projectedFields.length; ++i) {
            projections[i] = this.createProjection(this.projectedFields[i]);
        }
        if (this.tupleTransformer != null) {
            return factory.composite(list -> this.tupleTransformer.transform(list.toArray(), this.projectedFields), projections).toProjection();
        }
        return factory.composite(List::toArray, projections).toProjection();
    }

    private SearchProjection<?> createProjection(String field) {
        SearchProjectionFactory<?, ?> factory = this.scope.projection();
        if (field == null) {
            return factory.composite(ignored -> null, (ProjectionFinalStep)factory.documentReference()).toProjection();
        }
        switch (field) {
            case "__HSearch_This": {
                return factory.entity().toProjection();
            }
            case "__HSearch_Document": {
                return ((LuceneSearchProjectionFactory)factory.extension((SearchProjectionFactoryExtension)LuceneExtension.get())).document().toProjection();
            }
            case "__HSearch_Score": {
                return factory.score().toProjection();
            }
            case "__HSearch_id": {
                return this.scope.idProjection();
            }
            case "__HSearch_Explanation": {
                return ((LuceneSearchProjectionFactory)factory.extension((SearchProjectionFactoryExtension)LuceneExtension.get())).explanation().toProjection();
            }
            case "_hibernate_class": {
                return this.scope.objectClassProjection();
            }
            case "_HSearch_SpatialDistance": {
                return factory.distance(this.spatialFieldName, Coordinates.toGeoPoint(this.spatialSearchCenter)).unit(DistanceUnit.KILOMETERS).toProjection();
            }
        }
        if (field.startsWith(HSEARCH_PROJECTION_FIELD_PREFIX)) {
            throw log.unexpectedProjectionConstant(field);
        }
        return factory.field(field).toProjection();
    }

    private static enum TimeoutType {
        FAIL,
        TRUNCATE;

    }
}

