/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.data.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class HashTable<T>
implements Iterable<T> {
    final Object[] buckets;

    HashTable(int size) {
        this.buckets = new Object[size];
    }

    public final int size() {
        return this.buckets.length;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < HashTable.this.buckets.length;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return HashTable.this.buckets[this.index++];
            }
        };
    }

    public final T get(CharSequence key) {
        return this.get(this.computeIndex(key));
    }

    public final T get(int index) {
        return (T)this.buckets[index];
    }

    public final void set(int index, T value) {
        this.buckets[index] = value;
    }

    public abstract int computeIndex(CharSequence var1);
}

